/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamView
 * Author:   phone
 * Date:     2018/4/24 11:34
 * Description: 考试查看VO
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo.exam;

import com.yizhi.exam.application.vo.TrExamPointVO;
import com.yizhi.exam.application.vo.TrExamQuestionSortVO;
import com.yizhi.exam.application.vo.TrExamScoreEvaluateVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈考试查看VO〉
 *
 * @author phone
 * @create 2018/4/24
 * @since 1.0.0
 */
@Data
public class ExamView {

    @ApiModelProperty("考试ID")
    private Long id;

    @ApiModelProperty("考试名称")
    private String name;

    @ApiModelProperty("考试开始时间")
    private Date startTime;

    @ApiModelProperty("考试结束时间")
    private Date endTime;

    @ApiModelProperty("答卷时长（分钟）0无限制")
    private Integer duration;

    @ApiModelProperty("答题次数 0无限制")
    private Integer answerNum;

    @ApiModelProperty("合格分")
    private Integer qualifiedScore;

    @ApiModelProperty("考试说明")
    private String description;

    @ApiModelProperty("出题策略 1手动出题 2系统出题")
    private Integer makeStrategy;

    @ApiModelProperty("组卷策略 1 抽题组卷(所有学员使用同一分试卷) 2 随机组卷(所有学员使用不同试卷)")
    private Integer sysMakeStrategy;

    @ApiModelProperty("题干排序 1默认排序 2题型排序 3随机排序")
    private Integer stemSort;

    @ApiModelProperty("选项排序，1默认排序 2随机排序")
    private Integer optionSort;

    @ApiModelProperty("考试范围，1平台用户可见 2指定用户可见")
    private Integer visibleRange;

    @ApiModelProperty("呈现样式，1整页呈现 2逐题呈现")
    private Integer pageMode;

    @ApiModelProperty("显示答卷，0不显示 1交卷后显示 2考试结束后显示")
    private Integer isAnswerPaper;

    @ApiModelProperty("显示成绩，0不显示 1交卷后显示 2考试结束后显示")
    private Integer isScore;

    @ApiModelProperty("显示答案，0不显示 1交卷后显示 2考试结束后显示")
    private Integer isAnswer;

    @ApiModelProperty("显示解析，0不显示 1交卷后显示 2考试结束后显示")
    private Integer isAnalysis;

    @ApiModelProperty("是否使用积分，0不使用 1使用，默认0")
    private Integer isPoint;

    @ApiModelProperty("提醒设置，0否 1是，默认0")
    private Integer remind;

    @ApiModelProperty(value = "显示通用分评价，0不显示 1交卷后显示 2考试结束后显示")
    private Integer isPaperid;

    @ApiModelProperty("题型排序列表")
    List<TrExamQuestionSortVO> trExamQuestionSortVOS;

    @ApiModelProperty("通用分评价列表")
    List<TrExamScoreEvaluateVO> trExamScoreEvaluateVOS;

    @ApiModelProperty("考试积分列表")
    List<TrExamPointVO> trExamPointVOS;

    @ApiModelProperty("题型排序")
    private Integer typeSort;

    @ApiModelProperty("题库id")
    private Long libraryId;

    @ApiModelProperty("题库名称")
    private String libraryName;

    @ApiModelProperty("关键字,逗号分隔")
    private String keywords;

    @ApiModelProperty(value = "考试图片logo")
    private String image;

    @ApiModelProperty(value = "是否启用在日历任务中显示")
    private Integer enableTask;

}