package com.yizhi.exam.application.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("考试统计参数")
@Data
public class ReportExamParam {

	@ApiModelProperty("开始日期")
	private String startTime;
	
	@ApiModelProperty(value="结束日期")
	private String endTime;
	
	@ApiModelProperty("站点ID")
	private Long siteId;

	@ApiModelProperty(value = "企业ID",required = true)
	private Long companyId;

	@ApiModelProperty("组织Id")
	private Long orgId;
	
	@ApiModelProperty("管理权限组织ID集合")
	private List<Long> orgIds;

	@ApiModelProperty("搜索组织ID集合")
	private List<Long> searchOrgIds;
	
	@ApiModelProperty("搜索员工ID集合")
	private List<Long> searchAccountIds;
	

	@ApiModelProperty("当前页")
	private Integer pageNo;

	@ApiModelProperty("一页显示的条数")
	private Integer pageSize;
	
	@ApiModelProperty("考试关键字")
	private String examNameLike;
	
	@ApiModelProperty("统计类型")
	private String type;

	@ApiModelProperty("当前管理员是否是超级管理员")
	private boolean isAdmin;

	@ApiModelProperty("当前用户id")
	private Long accountId;
}