package com.yizhi.application.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.export.ExamAnswerExport;
import com.yizhi.application.service.IExamReportService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.ExamReportClient;
import com.yizhi.exam.application.vo.ExamCountByUserVO;
import com.yizhi.exam.application.vo.report.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 试报表统计Feign接口实现
 *
 * @author mei
 */
@RestController
@RequestMapping("/manage")
public class ExamReportController implements ExamReportClient {

    private static final Logger LOG = LoggerFactory.getLogger(ExamReportController.class);

    @Autowired
    ExamAnswerExport examAnswerExport;

    @Autowired
    IExamReportService iExamReportService;

    /**
     * 考试答卷导出(实时的继续使用,不迁到报表服务)
     *
     * @param paramMaps 参数MAP
     */
    @Override
    @GetMapping("/exam/answer/student/export")
    public void downStudentExamAnswer(@RequestParam Map<String, Object> paramMaps) {
        RequestContext res = ContextHolder.get();
        LOG.info("考试答卷导出  处理开始");
        paramMaps.put("isAdmin", res.isAdmin());
        LOG.info("考试答卷导出 downStudentExamAnswer 参数 = {}", JSON.toJSONString(paramMaps));
        examAnswerExport.execute(paramMaps, true);
    }

    /**
     * 按考试统计(迁到报表服务,将废弃)
     *
     * @param paramMaps
     * @return
     */
    @Override
    @GetMapping("/report/exam/group")
    public Page<ReportExamVO> getExamGroup(@RequestBody ReportExamParam reportExamParam) {
        Page<ReportExamVO> page = iExamReportService.getExamGroup(reportExamParam);
        return page;
    }

    /**
     * 按考试统计-查看（按分数段,实时的继续使用,不迁到报表服务）
     *
     * @param paramMaps
     * @return
     */
    @Override
    @GetMapping("/report/exam/score/group/view")
    public List<ReportExamChartsVo> getExamScoreGroupView(@RequestParam(name = "examId", required = true) Long examId,
                                                          @RequestParam(name = "startTime", required = false) String startTime,
                                                          @RequestParam(name = "endTime", required = false) String endTime) {

        return iExamReportService.getExamScoreGroupView(examId, startTime, endTime);
    }

    /**
     * 按考试统计-查看（按用户统计,迁到报表服务,将废弃）
     */
    @Override
    @GetMapping("/report/exam/group/account")
    public Page<ReportExamAccountsViewVo> getExamAndAccountGroup(@RequestBody ExamCountByUserVO vo) {
        return iExamReportService.getExamAndAccountGroup(vo);
    }

    /**
     * 按考试统计-查看（按用户统计）考试明细下载(实时的继续使用,不迁到报表服务)
     *
     * @param examId
     * @param accountNameLike
     * @param orgNameLike
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    @GetMapping("/report/exam/group/account/examView")
    public Page<ReportExamAccountsViewVo> getExamAndAccountGroupView(Long examId,
                                                                     Long siteId,
                                                                     Long accountId,
                                                                     boolean isAdmin,
                                                                     String accountNameLike,
                                                                     String orgNameLike,
                                                                     String startTime,
                                                                     String endTime,
                                                                     int pageNo,
                                                                     int pageSize) {
        return iExamReportService.getExamAndAccountGroupView(examId, siteId, accountId, isAdmin, accountNameLike, orgNameLike, startTime, endTime,
                pageNo, pageSize);
    }


    /**
     * 按考试统计-查看（按考题统计,实时的继续使用,不迁到报表服务）
     *
     * @param examId
     * @return
     */
    @Override
    @GetMapping("/report/exam/sub/group/view")
    public List<ReportExamSubjectChartsVotr> getExamSubGroupView(@RequestParam(name = "examId") Long examId,
                                                                 @RequestParam(name = "startTime", required = false) String startTime,
                                                                 @RequestParam(name = "endTime", required = false) String endTime) {

        Map<String, Object> param = new HashMap<>();
        param.put("examId", examId);
        param.put("startTime", startTime);
        param.put("endTime", endTime);

        //统计最高分的答卷数量
        Integer answerPageSize = 500;
        Integer answerTotal = iExamReportService.getMaxScoreeExamAnswerCount(param);
        Integer answerPageTotal = 1;
        if (answerTotal > answerPageSize) {
            answerPageTotal = answerTotal / answerPageSize;
            if (answerTotal % answerPageSize > 0) {
                answerPageTotal += 1;
            }
        }

        //题目所在列
        Map<Long, Map<String, Object>> subjectMaps = new HashMap<>();


        //按考生考试最高分答卷取出题目信息
        List<TrExamAnswer> trExamAnswers = null;    //答卷集合
        for (int i = 0; i < answerPageTotal; i++) {
            //分页查询考生答卷信息
            trExamAnswers = iExamReportService.getMaxScoreeExamAnswerInfo(param, i + 1, answerPageSize);
            if (null == trExamAnswers || trExamAnswers.size() == 0) {
                LOG.info("没查询到答卷信息：" + param.toString() + "pageNo:" + i * answerPageSize + " pageSize" + answerPageSize);
                continue;
            }

            Map<Long, Map<String, Object>> pageSubjectMaps = null;
            Map<Long, Map<String, Object>> rightSubjectMaps = null;

            //统计答题数量
            pageSubjectMaps = iExamReportService.getExamAnswerSubjectCountInfo(trExamAnswers, null);
            //户统计正确答题数,主观题不要统计
            rightSubjectMaps = iExamReportService.getExamAnswerSubjectCountInfo(trExamAnswers, 1);

            if (pageSubjectMaps != null) {
                for (Map.Entry<Long, Map<String, Object>> entry : pageSubjectMaps.entrySet()) {
                    Long key = entry.getKey();
                    Map<String, Object> subItem = subjectMaps.get(key);
                    Map<String, Object> map = (Map<String, Object>) entry.getValue();
                    Map<String, Object> rightMap = rightSubjectMaps.get(key);
                    if (rightMap == null) {
                        rightMap = new HashMap<>();
                    }
                    if (subItem == null) {
                        map.put("totalAccount", rightMap.get("totalAccount") == null ? 0 : Integer.valueOf(rightMap.get("totalAccount").toString()));
                        subjectMaps.put(key, map);
                    } else {
                        subItem.put("totalSub", Integer.valueOf(subItem.get("totalSub").toString())
                                + Integer.valueOf(map.get("totalSub").toString()));
                        subItem.put("totalAccount", Integer.valueOf(subItem.get("totalAccount").toString())
                                + Integer.valueOf(rightMap.get("totalAccount") == null ? "0" : rightMap.get("totalAccount").toString()));
                        subjectMaps.put(key, subItem);
                    }
                }
            }

//            //统计正确答题数量
//            for (TrExamAnswer trExamAnswer : trExamAnswers){
//                Long answerId = trExamAnswer.getId();
//                //客观题目总数和错误题数
//                List<Long> resWrongIds = iExamReportService.getWrongIds(answerId);
//                List<Long> resQuestionIds = iExamReportService.getQuestionIds(answerId);
//                if (CollectionUtils.isNotEmpty(resQuestionIds)) {
//                    for (Long subjectId : resQuestionIds) {
//                        if (CollectionUtils.isNotEmpty(resWrongIds)) {
//                            if (resWrongIds.contains(subjectId)) {
//                                continue;
//                            }
//                        }
//                        Map<String, Object> subItem = subjectMaps.get(subjectId);
//                        if (null != subItem) {
//                            subItem.put("totalAccount", Integer.valueOf(subItem.get("totalAccount").toString())
//                                    + 1);
//                            subjectMaps.put(subjectId, subItem);
//                        }
//
//                    }
//                }
//
//                //主观题目正确数,必须是满分(主观题目暂时不统计)
////            List<Long> resMaRightIds = iExamReportService.getResMaRightId(answerId, examId);
////            if (CollectionUtils.isNotEmpty(resMaRightIds)) {
////                for (Long subjectId : resMaRightIds) {
////                    Map<String, Object> subItem = subjectMaps.get(subjectId);
////                    if (null != subItem) {
////                        subItem.put("totalAccount", Integer.valueOf(subItem.get("totalAccount").toString())
////                                + 1);
////                        subjectMaps.put(subjectId, subItem);
////                    }
////                }
////            }
//
//            }

        }
        //获取该考试所有题目
        List<ReportExamSubjectChartsVotr> list = new ArrayList();
        list = iExamReportService.getExamSubGroupView(examId);
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReportExamSubjectChartsVotr item : list) {
                Long subjectId = item.getId();
                //答题总人数
                if (null != subjectMaps.get(subjectId)) {
                    Integer total = Integer.valueOf(subjectMaps.get(subjectId).get("totalSub").toString());
                    //正确人数
                    Integer rightNum = (Integer) subjectMaps.get(subjectId).get("totalAccount");
                    item.setTotalSub(total);
                    item.setTotalAccount(rightNum);
                    item.setName((String) subjectMaps.get(subjectId).get("name"));
                }
                Integer n = item.getSort();
                item.setValue("题目" + n);
            }
        }

        return list;
    }

    /**
     * 按用户统计(迁到报表服务,将废弃)
     *
     * @param paramMaps
     * @return
     */
    @Override
    @GetMapping("/report/exam/account/group")
    public Page<ReportExamAccountVO> getExamAccountGroup(@RequestBody ExamCountByUserVO vo) {

        return iExamReportService.getExamAccountGroup(vo);
    }

    /**
     * 按用户统计（查看,迁到报表服务,将废弃）
     */
    @GetMapping("/report/exam/account/group/view")
    public Page<ReportExamAccountViewVo> getExamAccountGroupView(@RequestParam(name = "accountId", required = true) Long accountId,
                                                                 @RequestParam(name = "startTime", required = true) String startTime,
                                                                 @RequestParam(name = "endTime", required = true) String endTime,
                                                                 @RequestParam(name = "examNameLike", required = false) String examNameLike,
                                                                 @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                                                 @RequestParam(name = "pageSize", required = true) Integer pageSize) {
        return iExamReportService.getExamAccountGroupView(accountId, startTime, endTime, examNameLike, pageNo, pageSize);
    }

}
