package com.yizhi.application.controller;


import com.yizhi.application.mapper.StatisticsExamMetadataMapper;
import com.yizhi.application.mapper.TrExamAuthorizeMapper;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.StatisticsExamLearnMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author dingxiaowei123
 * @since 2018-08-01
 */
@RestController
@RequestMapping("/manage/report/exam/")
public class StatisticsExamMetadataController {

//    @Autowired
//    private StatisticsExamMetadataRun statisticsExamMetadataRun;

    @Autowired
    private StatisticsExamMetadataMapper statisticsExamMetadataMapper;

    @Autowired
    private TrExamAuthorizeMapper trExamAuthorizeMapper;

    @GetMapping("/asynchronous/load")
    public String AsynchronousExam(@RequestParam("startDate") String startDate,
                                   @RequestParam("endDate") String endDate) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
//        statisticsExamMetadataRun.execute(map, true);
        return "";
    }


    /**
     * 报表报表获取考试列表
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/getAllExams")
    public List<Exam> getAllExams(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate) {
        return statisticsExamMetadataMapper.getAllExams(startDate, endDate);
    }


    /**
     * 报表服务获取所有考试最早开始时间
     *
     * @return
     */
    @GetMapping("/selectRecordMinTime")
    public Date selectRecordMinTime() {
        return statisticsExamMetadataMapper.selectRecordMinTime();
    }

    /**
     * 报表服务获取可见范围id(人或者组织)
     *
     * @param examId
     * @return
     */
    @GetMapping("/getRangeIds")
    public List<Long> getRangeIds(@RequestParam(value = "examId") Long examId) {
        return trExamAuthorizeMapper.selectRelationidByExamid(examId);
    }

    /**
     * 考试报表服务获取入库记录
     *
     * @param examId
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/getRecords")
    public List<StatisticsExamLearnMetadata> getRecords(@RequestParam("examId") Long examId, @RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate) {
        return statisticsExamMetadataMapper.getRecords(examId, startDate, endDate);
    }

    @GetMapping("/getAllExamSiteIds")
    public List<Long> getAllExamSiteIds(){
        return statisticsExamMetadataMapper.getAllExamSiteIds();
    }
}

