package com.yizhi.application.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.exam.application.vo.exam.SortVO;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.exam.application.vo.ExamQuestionLibraryVO;
import com.yizhi.exam.application.vo.ExamQuestionVO;
import com.yizhi.application.service.ITrExamQuestionService;
import com.yizhi.application.service.ITrQuestionLibrarySubjectService;


/**
 * <p>
 * 考试题目 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/manage/exam/question")
public class TrExamQuestionController {
	@Autowired
	ITrExamQuestionService trExamQuestionService;
	@Autowired
	ITrQuestionLibrarySubjectService iTrQuestionLibrarySubjectService;

	@Autowired
	ITrExamQuestionService iTrExamQuestionService;

	private static final org.slf4j.Logger Log = LoggerFactory.getLogger(TrExamQuestionController.class);

	/**
	 * 获得考试试题
	 * 
	 * @return
	 */
	@GetMapping("/list")
	public Map<String, Object> getQuestionList(
			@RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
			@RequestParam(name = "pageSize", defaultValue = "20", required = false) Integer pageSize,
			@RequestParam(name = "examId") Long examId) {
		Map<String,Object> map = null;
		try {
			//查询所有考试试题
			List<ExamQuestionLibraryVO> examQuestionLibraryVOS = trExamQuestionService.selectExamQuestionListById(examId, pageNo, pageSize);
			
			if(examQuestionLibraryVOS!=null&&examQuestionLibraryVOS.size()>0) {
			        int size=examQuestionLibraryVOS.size();	
					ExamQuestionLibraryVO eqlv=null;
					for (int i = 0; i < size; i++) {
						eqlv=examQuestionLibraryVOS.get(i);
						if(i>0) {
							//设置上行一个id
							eqlv.setPrevId(examQuestionLibraryVOS.get(i-1).getId());
						}
						if(i < size-1) {
							//设置下一个id
							eqlv.setNextId(examQuestionLibraryVOS.get(i+1).getId());
						}
					}
					List<ExamQuestionLibraryVO> examQuestionLibraryVOSNOW = null;
					//分页设置
					if(pageNo>1) {
						examQuestionLibraryVOSNOW=trExamQuestionService.selectExamQuestionListById(examId, pageNo-1, pageSize);
						examQuestionLibraryVOS.get(0).setNextId(examQuestionLibraryVOSNOW.get(examQuestionLibraryVOSNOW.size()-1).getId());
					}
					examQuestionLibraryVOSNOW=trExamQuestionService.selectExamQuestionListById(examId, pageNo+1, pageSize);
                    if(examQuestionLibraryVOSNOW!=null&&examQuestionLibraryVOSNOW.size()>0) {
                    	examQuestionLibraryVOS.get(examQuestionLibraryVOS.size()-1).setNextId(examQuestionLibraryVOSNOW.get(0).getId());
                    } 					
				}
			
			
			
			
			
			
			
			
//			List<TrQuestionLibrarySubject> trQuestionLibrarySubjects = iTrQuestionLibrarySubjectService.selectQuestionByLibrarySubjectId(trExamQuestions);
			ExamQuestionLibraryVO examQuestionLibraryVO;
			/*List<ExamQuestionLibraryVO> examQuestionLibraryVOS = new LinkedList<ExamQuestionLibraryVO>();
			for (TrExamQuestion trExamQuestion: trExamQuestions) {
				examQuestionLibraryVO = new ExamQuestionLibraryVO();
				examQuestionLibraryVO.setId(trExamQuestion.getId());
				examQuestionLibraryVO.setScore(trExamQuestion.getScore());
				examQuestionLibraryVO.setStatus(trExamQuestion.getState());
				for (TrQuestionLibrarySubject trQuestionLibrarySubject: trQuestionLibrarySubjects) {
					if (trExamQuestion.getSubjectId().longValue() == trQuestionLibrarySubject.getId().longValue()){
						examQuestionLibraryVO.setStem(trQuestionLibrarySubject.getStem());
						examQuestionLibraryVO.setType(trQuestionLibrarySubject.getType());
						examQuestionLibraryVO.setLibraryId(trQuestionLibrarySubject.getLibraryId());
						break;
					}
				}
				examQuestionLibraryVOS.add(examQuestionLibraryVO);
			}*/
			Integer sumNum = iTrExamQuestionService.sumNum(examId);
			Map<String,Integer> page = new HashMap<String,Integer>();
			page.put("pageNo",pageNo);
			page.put("pageSize",pageSize);
			page.put("pageTotal",sumNum);
			map = new HashMap<String,Object>();
			map.put("list",examQuestionLibraryVOS);
			map.put("page",page);
			return map;
		} catch (Exception e) {
			e.printStackTrace();
			Log.error("查询考试试题列表失败", e);
			return map;
		}
	}

	@PostMapping("/insert")
	public boolean insert(@RequestBody ExamQuestionVO examQuestionVO) {
		boolean result = false;
		try {
			result = iTrExamQuestionService.insertExamQuestionService(examQuestionVO);
		return result;
		} catch (Exception e) {
			Log.error("新建试题失败！", e);
			return result;
		}
	}

    @GetMapping("/exam/preview")
    public QuestionPreview examPreview(
            @RequestParam(value="examTitleId") Long examTitleId){
    	QuestionPreview questionPreview = trExamQuestionService.examPreview(examTitleId);
    	return questionPreview;
    }

    @PostMapping("/update/score")
    public boolean updateScoreById(@RequestBody ExamQuestionVO examQuestionVO){
		return trExamQuestionService.updateScoreById(examQuestionVO);
	}

	@PostMapping("/move")
	public boolean move(@RequestBody List<SortVO> sortVOS){
    	return trExamQuestionService.move(sortVOS);
	}

	@PostMapping("/delete/all")
	public Integer deleteAllById(@RequestBody List<Long> id){
		return trExamQuestionService.deleteById(id);
	}

	@GetMapping("/count")
	public Integer selectQuestionCountByExamId(@RequestParam("examId") Long examId){
		return trExamQuestionService.selectQuestionCountByExamId(examId);
	}

	@PostMapping("/save/one")
	public Long insertOne(@RequestBody TrExamQuestion trExamQuestion){
		return trExamQuestionService.insertOne(trExamQuestion);
	}

	@PostMapping("/update/question")
	public Integer updateQuestion(@RequestBody ExamQuestionVO examQuestionVO){
		return trExamQuestionService.updateExamQuestion(examQuestionVO);
	}
}
