package com.yizhi.application.controller.api;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yizhi.application.service.ITrExamAnswerService;
import com.yizhi.exam.application.vo.dashboard.ExamDashboardQueryVO;

@RestController
@RequestMapping("/api/exam/dashboard")
public class ExamDashboardController {
	
	@Autowired
	private ITrExamAnswerService examAnswerService;

	@PostMapping("/duration/get")
	public Map<Long, Integer> getExamDashboardData(@RequestBody ExamDashboardQueryVO query) {
		return examAnswerService.getExamDashboardData(query);
	}
}
