package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 题目
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_question_library_subject")
public class TrQuestionLibrarySubject extends Model<TrQuestionLibrarySubject> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("library_id")
	private Long libraryId;

	
	private Integer type;

	
	@TableField("question_label")
	private String questionLabel;
	
	
	private Integer state;

	
	private String stem;

	
	@TableField("stem_appendix_url")
	private String stemAppendixUrl;

	
	private String analysis;

	
	@TableField("score_rule")
	private String scoreRule;

	
	@TableField("old_library_id")
	private Long oldLibraryId;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	@TableField("company_id")
	private Long companyId;

	
	@TableField("org_id")
	private Long orgId;

	
	@TableField("site_id")
	private Long siteId;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}