package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.domain.TrExamAnswerQuestionRes;
import com.yizhi.application.domain.TrExamAnswerQuestionResMa;
import com.yizhi.exam.application.vo.ExamCountByUserVO;
import com.yizhi.exam.application.vo.ExamQuestionSubjectVo;
import com.yizhi.exam.application.vo.report.*;

import java.util.List;
import java.util.Map;

/**
 * 考试统计服务类
 *
 * @author mei
 */
public interface IExamReportService {
    /**
     * 合计最高分数答卷的考生数
     *
     * @param paramMap 条件MAP
     * @return
     */
    public Integer getMaxScoreeExamAnswerCount(Map<String, Object> paramMaps);

    /**
     * 合计最高分数答卷的考生信息
     *
     * @param paramMap 条件MAP
     * @param pageNo   页码
     * @param pageSize 每页显示数
     * @return
     */
    public List<TrExamAnswer> getMaxScoreeExamAnswerInfo(Map<String, Object> paramMaps,
                                                         Integer pageNo, Integer pageSize);

    /**
     * 查询考生考试题目数
     *
     * @param accountId
     * @param answerId
     * @return
     */
    public Integer selectExamAnswerSubjectByAccountIdCount(Long accountId, Long answerId);

    /**
     * 查询考生考试题目
     *
     * @param accountId 学号ID
     * @param answerId  答卷ID
     * @return
     */
    public List<ExamQuestionSubjectVo> getExamAnswerSubjectByAccountId(Long accountId, Long answerId,
                                                                       Integer pageNo, Integer pageSize);

    /**
     * 获取客观题选项
     *
     * @param answerId
     * @param answerQuestionId
     * @param subjectId
     * @return
     */
    public List<TrExamAnswerQuestionRes> getExamAnswerSubjectOption(Long answerId, Long answerQuestionId, Long subjectId);

    /**
     * 获取主管题选项
     *
     * @param answerId
     * @param answerQuestionId
     * @return
     */
    public TrExamAnswerQuestionResMa getExamAnswerSubjectOptionMain(Long answerId, Long answerQuestionId);


    /**
     * 按考试统计
     *
     * @param paramMaps
     * @return
     */
    Page<ReportExamVO> getExamGroup(ReportExamParam reportExamParam);


    /**
     * 按考试统计-查看（按用户统计）
     *
     * @param examId
     * @return
     */
    Page<ReportExamAccountsViewVo> getExamAndAccountGroup(ExamCountByUserVO vo);

    /**
     * 按考试统计-查看（按用户统计）考试明细下载
     *
     * @param accountId
     * @param examId
     * @param startTime
     * @param endTime
     * @return
     */
    Page<ReportExamAccountsViewVo> getExamAndAccountGroupView(Long examId,
                                                              Long siteId,
                                                              Long accountId,
                                                              boolean isAdmin,
                                                              String accountNameLike,
                                                              String orgNameLike,
                                                              String startTime,
                                                              String endTime,
                                                              int pageNo,
                                                              int pageSize);

    /**
     * 按考试统计-查看（按分数段统计）
     *
     * @param examId
     * @return
     */
    List<ReportExamChartsVo> getExamScoreGroupView(Long examId, String startTime, String endTime);

    /**
     * 按考试统计-查看（按考题统计）
     *
     * @param examId
     * @return
     */
    List<ReportExamSubjectChartsVotr> getExamSubGroupView(Long examId);

    /**
     * 按用户统计
     *
     * @param paramMaps
     * @return
     */
    Page<ReportExamAccountVO> getExamAccountGroup(ExamCountByUserVO vo);

    /**
     * 按用户统计查看
     */
    Page<ReportExamAccountViewVo> getExamAccountGroupView(Long accountId, String startTime, String endTime, String examNameLike,
                                                          Integer pageNo, Integer pageSize);

    /**
     * 获取答题人数或正确答题人数
     *
     * @param answerIds 答卷集合
     * @param isRight   是否统计正确答题人数
     * @return
     */
    public Map<Long, Map<String, Object>> getExamAnswerSubjectCountInfo(List<TrExamAnswer> answerIds, Integer isRight);

    /**
     * 获取客观题正确答对数
     *
     * @param answerId
     * @return
     */
    Integer getWrongCount(Long answerId);

    /**
     * 获取客观题目总数
     *
     * @param answerId
     * @return
     */
    Integer getQuestionCount(Long answerId);

    List<Long> getResMaRightId(Long answerId, Long examId);

    List<Long> getWrongIds(Long answerId);

    List<Long> getQuestionIds(Long answerId);
}
