package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.application.domain.TrQuestionLibrarySubject;
import com.yizhi.exam.application.vo.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 题目 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrQuestionLibrarySubjectService extends IService<TrQuestionLibrarySubject> {
	/**
	 * 根据题目Id，找到题目对象
	 * @param QuestionId
	 * @return
	 */
	TrQuestionLibrarySubject selectQuestionById(Long QuestionId);

	/*
	* 根据题目ID获取题目详情
	* **/
	QuestionLibrarySubjectVO selectQuestionLibrarySubject(Long id);

	/**
	 * 查询出所有的题目
	 * @return
	 */
	List<TrQuestionLibrarySubject> selectQuestion();
	/**
	 * 根据题库id找到此题库有多少题目
	 * @param libraryId
	 * @return
	 */
	Integer subjectSumNum(Long id);
	/**
	 * 根据题库id，找到所有的题目
	 * @param LibraryId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	List<TrQuestionLibrarySubject> selectQuestionByLibraryId(Long LibraryId,Integer pageNo,Integer pageSize,String key,Integer type);
	
	Page<SelectQuestionVO> listExamQuestion(Map<String, Object> map, Page<SelectQuestionVO> page);
	
	/**
	 * 删除题库试题
	 * @param id
	 * @param ids
	 * @return
	 */
	Boolean questionDeleteBatch(List<Long> ids);
	
	/**
	 * 根据考试题目表中题目ID查询题目
	 * */
	List<TrQuestionLibrarySubject> selectQuestionByLibrarySubjectId(List<TrExamQuestion> trExamQuestions);

	Long insert(TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) throws Exception;

	int update(TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO);

	List<LibrarySubjectVO> selectLibrarySubjectList(ContextAndPageSizeVO contextAndPageSizeVO);

	Integer selectLibrarySubjectCount(ContextAndPageSizeVO contextAndPageSizeVO);

	Integer selectLibrarySubjectsCount(Long libraryId,String key,Integer type);

	Integer selectIsUser(Long id);

	boolean insertList(List<TrQuestionLibrarySubjectVO> trQuestionLibrarySubjectVOList);
}