package com.yizhi.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.application.constant.ExamConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.Exam;
import com.yizhi.application.domain.TrExamPoint;
import com.yizhi.exam.application.vo.TrExamPointVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.ExamMapper;
import com.yizhi.application.mapper.TrExamPointMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamPointService;

/**
 * <p>
 * 考试积分 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamPointServiceImpl extends ServiceImpl<TrExamPointMapper, TrExamPoint> implements ITrExamPointService {

	@Autowired
	private IdGenerator idGenerator;

	@Autowired
	private ExamMapper examMapper;
	
	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<TrExamPointVO> listTrExamPoint(Long examId) {
		List<TrExamPointVO> list = new ArrayList<TrExamPointVO>();
		Exam exam = examMapper.selectById(examId);
		if(exam == null || exam.getIsPoint() == 0){
			return list;
		}
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		map.put("state", ExamConstant.FIRST);
		List<TrExamPoint> selectByMap = this.selectByMap(map);
		TrExamPointVO vo = null;
		for (TrExamPoint tp : selectByMap) {
			vo = new TrExamPointVO();
			vo.setId(tp.getId());
			vo.setExamId(examId);
			vo.setMaxScore(tp.getMaxScore());
			vo.setMinScore(tp.getMinScore());
			vo.setPoint(tp.getPoint());
			vo.setState(tp.getState());
			list.add(vo);
		}
		return list;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamPointList(List<TrExamPointVO> trExamPointVoList,Long accountId,String accountName, Long examId) {
		boolean result = false;
		List<TrExamPoint> list = new ArrayList<TrExamPoint>();
		List<TrExamPoint> updateList = new ArrayList<TrExamPoint>();
		
		//先删除在保存
		TrExamPoint trExamPoint =new TrExamPoint();
		trExamPoint.setExamId(examId);
		EntityWrapper<TrExamPoint> wrapper = new EntityWrapper<TrExamPoint>(trExamPoint);
		this.delete(wrapper);
		
		TrExamPoint tep = null;
		Date time = new Date();
		for (TrExamPointVO vo : trExamPointVoList) {
			tep = new TrExamPoint();
			if (vo.getId() == null) {		//新增
				tep.setId(idGenerator.generate());
				tep.setExamId(examId);
				tep.setMinScore(vo.getMinScore());
				tep.setMaxScore(vo.getMaxScore());
				tep.setPoint(vo.getPoint());
				tep.setState(ExamConstant.FIRST);
				tep.setCreateById(accountId);
				tep.setCreateByName(accountName);
				tep.setCreateTime(time);
				tep.setUpdateById(accountId);
				tep.setUpdateByName(accountName);
				tep.setUpdateTime(time);
				list.add(tep);
			} else {					//修改
				tep = this.selectById(vo.getId());
				if(null != tep){
					tep.setMinScore(vo.getMinScore());
					tep.setMaxScore(vo.getMaxScore());
					tep.setPoint(vo.getPoint());
					tep.setState(vo.getState());
					tep.setUpdateById(accountId);
					tep.setUpdateByName(accountName);
					tep.setUpdateTime(time);
					updateList.add(tep);
				}
			}
		}
		if (list.size() > 0) {
			result = this.insertBatch(list);
		}
		if (updateList.size() > 0) {
			result = this.updateBatchById(updateList);
			
			//找出被删除记录并更新成删除状态
			//examMapper.deleteUnExamPoint(accountId, accountName, examId, updateList);
		}
		return result;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyTrExamPoint(Long oldId, Long examId) {
		List<TrExamPoint> list = new ArrayList<TrExamPoint>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("state", ExamConstant.FIRST);
		map.put("exam_id", oldId);
		List<TrExamPoint> selectByMap = this.selectByMap(map);
		TrExamPoint tq = null;
		for (TrExamPoint tep : selectByMap) {
			tq = new TrExamPoint();
			BeanUtils.copyProperties(tep, tq);
			tq.setId(idGenerator.generate());
			tq.setExamId(examId);
			setInsertCloumn(tq, true);
			list.add(tq);
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}

	public void setInsertCloumn(TrExamPoint tq, boolean boo) {
		Long accountId = null;
		String accountName = null;
		RequestContext requestContext = ContextHolder.get();
		if (null != requestContext) {
			if (null != requestContext.getAccountId()) {
				accountId = requestContext.getAccountId();
			}
			if (null != requestContext.getAccountName()) {
				accountName = requestContext.getAccountName();
			}
		}
		accountId = 9999L;
		accountName = "bob";

		if (boo) {
			tq.setCreateById(accountId);
			tq.setCreateByName(accountName);
			tq.setCreateTime(new Date());
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		} else {
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		}
	}
	
	@Override
	public boolean insertAll(List<TrExamPoint> trExamPoints) {
		return this.insertBatch(trExamPoints);
	}

}