package com.yizhi.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamQuestionSort;
import com.yizhi.exam.application.vo.TrExamQuestionSortVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamQuestionSortMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamQuestionSortService;

/**
 * <p>
 * 试题类型排序（类型为：题型排序，有效） 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamQuestionSortServiceImpl extends ServiceImpl<TrExamQuestionSortMapper, TrExamQuestionSort>
		implements ITrExamQuestionSortService {

	@Autowired
	private IdGenerator idGenerator;

	@Transactional(propagation = Propagation.REQUIRED)
	public List<TrExamQuestionSortVO> listTrExamQuestionSort(Long examId) {
		List<TrExamQuestionSortVO> list = new ArrayList<TrExamQuestionSortVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		List<TrExamQuestionSort> selectByMap = this.selectByMap(map);
		for (TrExamQuestionSort ts : selectByMap) {
			TrExamQuestionSortVO vo = new TrExamQuestionSortVO();
			BeanUtils.copyProperties(ts, vo);
			list.add(vo);
		}
		return list.stream().sorted((p1, p2) -> p1.getSort().compareTo(p2.getSort())).collect(Collectors.toList());
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamQuestionSortList(List<TrExamQuestionSortVO> trExamQuestionSortVoList, Long examId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		this.deleteByMap(map);

		List<TrExamQuestionSort> list = new ArrayList<TrExamQuestionSort>();
		if (trExamQuestionSortVoList.size() > 0) {
			TrExamQuestionSort teqs = null;
			TrExamQuestionSortVO vo = null;
			for (int i = 0; i < trExamQuestionSortVoList.size(); i++) {
				vo = trExamQuestionSortVoList.get(i);
				teqs = new TrExamQuestionSort();
				teqs.setId(idGenerator.generate());
				teqs.setExamId(examId);
				teqs.setType(vo.getType());
				teqs.setSort(i + 1);
				setInsertCloumn(teqs);
				list.add(teqs);
			}
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyTrExamQuestionSort(Long oldId, Long examId) {
		List<TrExamQuestionSort> list = new ArrayList<TrExamQuestionSort>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", oldId);
		List<TrExamQuestionSort> trExamQuestionSortList = this.selectByMap(map);
		TrExamQuestionSort tes = null;
		for (TrExamQuestionSort ts : trExamQuestionSortList) {
			tes = new TrExamQuestionSort();
			BeanUtils.copyProperties(ts, tes);
			tes.setId(idGenerator.generate());
			tes.setExamId(examId);
			setInsertCloumn(tes);
			list.add(tes);
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}

	public void setInsertCloumn(TrExamQuestionSort tq) {
		Long accountId = null;
		String accountName = null;
		RequestContext requestContext = ContextHolder.get();
		if (null != requestContext) {
			if (null != requestContext.getAccountId()) {
				accountId = requestContext.getAccountId();
			}
			if (null != requestContext.getAccountName()) {
				accountName = requestContext.getAccountName();
			}
		}
		accountId = 9999L;
		accountName = "bob";

		tq.setCreateById(accountId);
		tq.setCreateByName(accountName);
		tq.setCreateTime(new Date());
		tq.setUpdateById(accountId);
		tq.setUpdateByName(accountName);
		tq.setUpdateTime(new Date());
	}
	
	@Override
	public boolean insertAll(List<TrExamQuestionSort> trExamQuestionSorts) {
		return this.insertBatch(trExamQuestionSorts);
	}

}
