package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(value = "ExamDetailsVO", description = "")
@Data
public class ExamCalendarVO {

	@ApiModelProperty(value = "考试id")
	private Long id;

	@ApiModelProperty(value = "考试名称")
	private String name;

	@ApiModelProperty(value = "开始时间")
	private Date startTime;

	@ApiModelProperty(value = "结束时间")
	private Date endTime;

	@ApiModelProperty(value = "答题次数，已经答题了的次数")
	private Integer answerNum;

	@ApiModelProperty(value = "考试次数，允许考试参加的次数 0：不限")
	private Integer examNum;

	@ApiModelProperty(value="考试状态：1、未答卷 2、继续答卷 3、待批阅 4、未通过")
	private Integer examStatus;

	@ApiModelProperty("业务按钮状态")
	public List<String> taskButtonStatus;

	@ApiModelProperty("业务状态标签")
	public String taskTag;
}
