
/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: QuestionLibraryVO
 * Author:   phone
 * Date:     2018/3/14 13:47
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 〈题库VO类〉<br>
 * 〈〉
 *
 * @author fanchunhui
 * @create 2018/3/14
 * @since 1.0.0
 */
@ApiModel(value = "QuestionLibraryVO", description = "题库")
@Data
public class QuestionLibraryVO {

	@ApiModelProperty(value = "题库ID主键")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	@ApiModelProperty(value = "题库名称，最多可输入20个汉字")
	private String name;

	@ApiModelProperty(value = "题库标签，多个用逗号分割")
	private String libraryLabel;

	@ApiModelProperty("题库类型：1-测试，2-问卷，3-投票")
	private Integer libraryType;

	@ApiModelProperty(value = "备注")
	private String comments;

	@ApiModelProperty(value = "题目数量")
	private Integer count;

	@ApiModelProperty(value = "状态，0删除 1未使用 2已使用，默认1")
	private Integer state;

	@ApiModelProperty(value = "题库总题目")
	private Integer sumNum;

	@ApiModelProperty(value = "试题列表")
	private List<QuestionLibrarySubjectVO> questionLibrarySubjectVOS;

	@ApiModelProperty(value = "题库列表")
	List<QuestionLibraryDetailsVO> list;

	@ApiModelProperty(value = "企业ID")
	Long companyId;

	@ApiModelProperty(value = "站点ID")
	Long siteId;

	@ApiModelProperty(value = "操作人ID")
	Long accountId;

	@ApiModelProperty(value = "操作人姓名")
	String accountName;

	@ApiModelProperty(value = "部门ID")
	Long orgId;
}
