package com.yizhi.exam.application.vo;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 提醒设置
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamRemindVO", description = "提醒设置")
@Data
public class TrExamRemindVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "考试主键_ID，外键")
	private Long examId;

	@ApiModelProperty(value = "1邮件 2站内消息")
	private String type;

	@ApiModelProperty(value = "提醒内容")
	private String content;

	@ApiModelProperty(value = "提醒模版ID")
	private Long templateId;

	@ApiModelProperty(value = "状态 0无效 1有效")
	private Integer state;

	@ApiModelProperty(value = "提醒模板对应的标题")
	private String name;

	@ApiModelProperty(value = "提醒时间设置")
	private List<TrExamRemindTimeVO> trExamRemindTimeVoList;

	@ApiModelProperty(value = "关键词")
	private String keywords;

}
