package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 考试分数通用评价
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamScoreEvaluate", description = "考试分数通用评价")
@Data

public class TrExamScoreEvaluate  {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "考试分数通用评价主键ID")
	private Long id;

	@ApiModelProperty(value = "考试主键_ID，外键")
	
	private Long examId;

	@ApiModelProperty(value = "最小分数")
	
	private Integer minScore;

	@ApiModelProperty(value = "最大分数")
	
	private Integer maxScore;

	@ApiModelProperty(value = "说明")
	private String description;

	@ApiModelProperty(value = "状态，0删除 1有效，默认1")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

}