package com.yizhi.exam.application.vo.exam;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamResultVO", description = "考试结果")
@Data
public class ExamResultVO {
    @ApiModelProperty(value = "考试ID")
    private Long examId;

    @ApiModelProperty(value = "考试完成后，查看试卷取最高分的答卷ID")
    private Long answerId;

    @ApiModelProperty(value = "考试开始时间")
    private Date startTime;

    @ApiModelProperty(value = "考试结束时间")
    private Date endTime;

    @ApiModelProperty(value = "考试名称")
    private String examName;

    @ApiModelProperty(value = "考试得分")
    private BigDecimal score;

    @ApiModelProperty(value = "考试评价")
    private String remark;

    @ApiModelProperty(value = "考试历史")
    private List<ExamHistoryVO> hisList;

    @ApiModelProperty(value = "是否存在主观题：0不存在1存在")
    private Integer isres = 0;

    @ApiModelProperty(value = "显示查看答卷，0不显示 1显示")
    private Integer isLookAnswer = 0;

    @ApiModelProperty(value = "显示成绩，0不显示 1显示")
    private Integer isScore = 0;

    @ApiModelProperty("发放的考试积分")
    private Integer point;

    @ApiModelProperty("考试合格分")
    private Integer scoreSuccess;

    @ApiModelProperty(value = "考试次数，0无限制 >0有限次(次)")
    private Integer answerNum;

    @ApiModelProperty(value = "已提交和阅卷的次数")
    private Integer examNum;

    @ApiModelProperty(value = "所有状态的考试的次数")
    private Integer examNumAll;

    @ApiModelProperty(value = "是否再考一次")
    private Integer isGoOn;

    @ApiModelProperty(value = "是否继续提交 1已经没有考试次数不能提交 2已经提交过了不能提交")
    private Integer isExamAnswerGoOn;

    /**
     * job定时后台发送消息需要
     */
    @ApiModelProperty(value = "学员id")
    private Long accountId;

    /**
     * job定时后台发送消息需要
     */
    @ApiModelProperty(value = "企业id")
    private Long companyId;

    /**
     * job定时后台发送消息需要
     */
    @ApiModelProperty(value = "站点id")
    private Long siteId;

    /**
     * job定时后台发送消息需要
     */
    @ApiModelProperty(value = "部门id")
    private Long orgId;
}
