package com.yizhi.exam.application.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 考试统计按用户分组统计
 * @author mei
 *
 */
@ApiModel("按用户分组统计VO")
@Data
public class ReportExamAccountVO {

    @ApiModelProperty("用户ID")
    private Long accountId;

    @ApiModelProperty("用户")
    private String accountName;

    @ApiModelProperty("姓名")
    private String accountFullName;

    @ApiModelProperty("所在部门")
    private String orgName;

    @ApiModelProperty("所在组织架构")
    private String orgNames;

    @ApiModelProperty("应参加考试数（空返回0）")
    private Integer totalAsk = 0;

    @ApiModelProperty("实际参加考试数（空返回0）")
    private Integer totalIn = 0;

    @ApiModelProperty("已通过考试数（空返回0）")
    private Integer totalPass = 0;

    @ApiModelProperty("未通过考试数（空返回0）")
    private Integer totalFail = 0;

    @ApiModelProperty("通过率")
    private BigDecimal passRate;

    @ApiModelProperty("用户状态（启用1，未启用0）")
    private  Integer accountState;


}
