//package com.yizhi.application.controller;
//
//import java.text.ParseException;
//import java.text.SimpleDateFormat;
//import java.util.ArrayList;
//import java.util.Calendar;
//import java.util.Date;
//import java.util.GregorianCalendar;
//import java.util.HashMap;
//import java.util.Iterator;
//import java.util.List;
//import java.util.Map;
//
//import org.apache.commons.collections.CollectionUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//
//import com.alibaba.fastjson.JSON;
//import com.yizhi.api.domain.Exam;
//import com.yizhi.api.domain.StatisticsExamLearnMetadata;
//import com.yizhi.api.domain.StatisticsExamMetadata;
//import com.yizhi.api.domain.TrExamAuthorize;
//import com.yizhi.core.application.context.TaskContext;
//import com.yizhi.application.feign.PointUserFeignClients;
//import com.yizhi.core.application.file.task.AbstractDefaultTask;
//import StatisticsExamLearnMetadataMapper;
//import StatisticsExamMetadataMapper;
//import com.yizhi.application.orm.id.IdGenerator;
//import IStatisticsExamMetadataService;
//import com.yizhi.system.application.system.remote.ReportClient;
//import com.yizhi.application.util.page.PageInfo;
//import com.yizhi.application.vo.ReportAccountRespVO;
//import com.yizhi.application.vo.ReportRangeAccountReqVO;
//
///**
// * 功能描述: 考试信息整合入库
// *
// * @param:
// * @return:
// * @auther: dingxiaowei
// * @date: 2018/8/2 下午2:02
// */
//@Component
//public class StatisticsExamMetadataRun extends AbstractDefaultTask<String, Map<String, Object>> {
//
//    private Logger logger = LoggerFactory.getLogger(StatisticsExamMetadataRun.class);
//
//    @Autowired
//    private ReportClient reportClient;
//
//    // 分页获取学员学习信息
//    int pageNo = 1;
//    int pageSize = 100;
//
//    /**
//     * 缓存学员学习信息
//     */
//    private final Map<String, Map<Long, StatisticsExamMetadata>> accountMap = new HashMap<String, Map<Long, StatisticsExamMetadata>>();
//
//    @Autowired
//    private StatisticsExamMetadataMapper statisticsExamMetadataMapper;
//
//    @Autowired
//    private StatisticsExamLearnMetadataMapper statisticsExamLearnMetadataMapper;
//
//    @Autowired
//    IStatisticsExamMetadataService iStatisticsExamMetadataService;
//
//    @Autowired
//    private PointUserFeignClients pointUserFeignClients;
//
//    @Autowired
//    IdGenerator idGenerator;
//
//    @Override
//    protected String execute(Map<String, Object> map) {
//        //获取统计的开始和结束时间
//        Date startRunDate = new Date();
//
//        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
//
//        Long taskId = idGenerator.generate();
//        TaskContext taskContext = new TaskContext(taskId, formatDate.format(startRunDate) + " 考试报表分析", 999L, startRunDate);
////        working(taskContext);
//
//        String startDate = null;
//        String endDate = null;
//        Date dCurDate = null;
//
//        boolean isRunDel = true;
//
//        if (map != null) {
//            startDate = (String) map.get("startDate");
//            endDate = (String) map.get("endDate");
//        }
//
//        if (startDate == null || "".equals(startDate)) {
//            Date middleMaxTime = statisticsExamMetadataMapper.selectMaxDate();
//            if (middleMaxTime != null) {
//                dCurDate = addDay(middleMaxTime, 1);
//                startDate = formatDate.format(dCurDate);
//                isRunDel = true;
//            } else {
//                Date recordMinTime = statisticsExamMetadataMapper.selectRecordMinTime();
//                startDate = formatDate.format(recordMinTime);
//                isRunDel = false;
//            }
//        }
//        if (endDate == null || "".equals(endDate)) {
//            dCurDate = addDay(new Date(), -1);
//            endDate = formatDate.format(dCurDate);
//        }
//
//        Long day = 0L;
//        Date beginDate = null;
//        try {
//            beginDate = formatDate.parse(startDate);
//            Date end = formatDate.parse(endDate);
//            day = (end.getTime() - beginDate.getTime()) / (24 * 60 * 60 * 1000);
//        } catch (ParseException e1) {
//            return null;
//        }
//
//        // 获得所有的考试Id
//        List<Exam> Exams = statisticsExamMetadataMapper.getAllExams(startDate, endDate);
//
//        List<StatisticsExamMetadata> insertList = new ArrayList<StatisticsExamMetadata>();
//
//        //指定范围可见的考试人员的IdList
//        List<Long> listAccountIdRange = null;
//
//        //第一次初始化数据，不执行删除
//        if(isRunDel){
//        	// 先删除这天的记录再添加，防止一天添加多次记录
//        	for (int d = 0; d <= day; d++) {
//                String currentDate = startDate;
//                if (d > 0) {
//                    dCurDate = addDay(beginDate, d);
//                    currentDate = formatDate.format(dCurDate);
//                }
//                statisticsExamMetadataMapper.deleteRecordeByDate(currentDate);
//            }
//        }
//
//
//        taskDetail(taskId, "***** 考试统计开始  *****");
//
//        List<TrExamAuthorize> listExamAccountIdRange = null;
//
//        String rangeKey = "";
//        List<StatisticsExamLearnMetadata> accountLearnIds = null;
//
//        boolean isOk = true;
//        String errMsg = "";
//        String curExamName = "";
//        Long curExamId = 0L;
//
//        try {
//            // 按考试遍历,获取考试的Id，名称，开始时间，结束时间，创建时间，企业Id，部门Id，站点Id，合格分
//            for (Exam exam : Exams) {
//                Long examId = exam.getId();
//                String examName = exam.getName();
//                curExamId = examId;
//                curExamName = examName;
//
//                Long examSiteId = exam.getSiteId();
//
//                //添加考试应参加人员信息
//                Integer scope = exam.getVisibleRange();  //可见范围 0 游客 1 平台用户 2 指定范围
//                if (scope != null && scope == 2) {   //如果是指定范围  不是根据站点Id找人
//                    examSiteId = null;
//                    listExamAccountIdRange = statisticsExamMetadataMapper.getExamRangeByExamId(examId);
//                    if (null == listExamAccountIdRange) {
//                        taskDetail(taskId,
//                                examName + "(" + examId + ")" + " 未设置指定范围，请确认是否为该考试设置的范围,无法统计数据");
//                        rangeKey = "";
//                    } else {
//                        listAccountIdRange = new ArrayList<Long>();
//                        for (TrExamAuthorize item : listExamAccountIdRange) {
//                            listAccountIdRange.add(item.getRelationId());
//                        }
//                        rangeKey = exam.getSiteId().toString() + listAccountIdRange.toString();
//                    }
//                } else {
//                    listAccountIdRange = null;
//                    if (examSiteId != null) {
//                        rangeKey = examSiteId.toString();
//                    } else {
//                        rangeKey = "";
//                        taskDetail(taskId,
//                                examName + "(" + examId + ")" + " 全平台可见为空:(" + examSiteId + ") 请确认数据,无法统计数据");
//                    }
//                }
//                if ("".equals(rangeKey)) {
//                    continue;
//                }
//
//                // 从缓存中获取用户，没有找到再请求system查询
//                Map<Long, StatisticsExamMetadata> resultccountMap = accountMap.get(rangeKey);
//                if (resultccountMap == null) {
//                    resultccountMap = new HashMap<Long, StatisticsExamMetadata>();
//                    getReportAccountRespVO(exam.getSiteId(), listAccountIdRange, pageNo, pageSize, null, resultccountMap, rangeKey, taskId, examName + "(" + examId + ")");
//                    if (resultccountMap.size() == 0) {
//                        if (examSiteId == null) {
//                            taskDetail(taskId, examName + "(" + examId + ")" + " 没有查找到指定范围IDs:(" + listAccountIdRange.toString() + ") 的学员信息,无法统计数据");
//                        } else {
//                            taskDetail(taskId, examName + "(" + examId + ")" + " 没有查找到全平台:(" + examSiteId + ") 的学员信息,无法统计数据");
//                        }
//                        continue;
//                    }
//                }
//                if (resultccountMap != null) {
//                    //添加应参加学员信息
//                    insertEmptyExamLearn(resultccountMap, exam, insertList, taskId);
//                }
//
//                //循环统计每天的学习记录
//                for (int d = 0; d <= day; d++) {
//                    String currentDate = startDate;
//                    if (d > 0) {
//                        dCurDate = addDay(beginDate, d);
//                        currentDate = formatDate.format(dCurDate);
//                    }
//
//                    //批量添加当前日期学习记录
//                    accountLearnIds = iStatisticsExamMetadataService.insertAccountLearn(examId, currentDate);
//                    //没有学习记录，跳转
//                    if (accountLearnIds == null || accountLearnIds.size() == 0) {
//                        continue;
//                    }
//
//                    // 遍历有学习的学员信息统计他们的学习情况，并更新统计表中存在的记录：更新条件ID
//                    for (StatisticsExamLearnMetadata statExam : accountLearnIds) {
//                        Long accountId = statExam.getAccountId();
//                        // 实际参加学习状态
//                        statExam.setJoinState(1);
//
//                        // 获取积分
//                        try {
//                            statExam.setPoint(pointUserFeignClients.acquirePoint(accountId, examId, currentDate));
//                        } catch (Exception e) {
//                            taskDetail(taskId,
//                                    statExam.getExamName() + "(" + statExam.getId() + ")" + " 获取积分服务不可用: " + e.getMessage());
//                        }
//
//                        // 更新已学习的学员信息
//                        statisticsExamLearnMetadataMapper.updateById(statExam);
//                    }
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            isOk = false;
//            taskDetail(taskId, "统计考试 " + curExamName + "(" + curExamId + ")异常:" + e.getMessage());
//            errMsg = e.getMessage();
//        }
//
//
//        try {
//            //添加考试，先删除后添加信息
//            statisticsExamMetadataMapper.deleteStatisticsExamToGroupFind();
//            statisticsExamMetadataMapper.insertStatisticsExamToGroupFind();
//
//            //添加学员，先删除后添加信息
//            statisticsExamMetadataMapper.deleteStatisticsExamToAccountGroupFind();
//            statisticsExamMetadataMapper.insertStatisticsExamToAccountGroupFind();
//
//        } catch (Exception e) {
//            logger.info("***** 添加数据到按部门统计表错误 *****");
//            taskDetail(taskId, "添加数据到中间表异常:" + e.getMessage());
//            isOk = false;
//            errMsg = e.getMessage();
//        }
//
//        accountMap.clear();
//
//        Date endRunDate = new Date();
//
//        String con = "考试报表分析完成耗时 :" + (endRunDate.getTime() - startRunDate.getTime()) / 1000 + "秒";
//        taskDetail(taskId, con);
//        if (isOk) {
//            success(taskContext, con);
//        } else {
//            fail(taskContext, con + ",执行过程中有错误:" + errMsg);
//        }
//
//
//        return "123";
//    }
//
//    /**
//     * 创建和获取学员学习对象，缓存全平台可见的学员对象
//     *
//     * @param siteId              站点ID，为空不缓存学员信息
//     * @param orgIdsAndAccountIds 指定范围可见ID集合
//     * @param pageNo              页码
//     * @param pageSize            页数
//     * @param resultAccountIds    保存当前查询的学员IDs，每次会清空集合中的记录
//     * @param resultccountMap     保存当前查询的学员信息，每次会清空集合中的记录
//     * @return 当前查询的学员IDs
//     */
//    private StatisticsExamMetadata getReportAccountRespVO(Long siteId, List<Long> orgIdsAndAccountIds, Integer pageNo, Integer pageSize,
//                                                          Long findAccountId, Map<Long, StatisticsExamMetadata> resultccountMap, String rangeKey, Long taskId, String taskCon) {
//
//        //查找指定的人
//        StatisticsExamMetadata learnStu = null;
//
//        // 获取用户信息
//        ReportRangeAccountReqVO rrarv = new ReportRangeAccountReqVO();
//        rrarv.setSiteId(siteId);
////        rrarv.setPageNo(pageNo);
////        rrarv.setOrgIdsAndAccountIds(orgIdsAndAccountIds);
////
////        rrarv.setPageSize(pageSize);
//        PageInfo<ReportAccountRespVO> page = null;
//        try {
////            page = reportClient.getRangeAccounts(rrarv);
//            if (page == null || page.getRecords() == null) {
//                return null;
//            }
//            learnStu = initStatisticsExamMetadatas(page.getRecords(), findAccountId, resultccountMap, rangeKey, taskId, taskCon);
//
//            String msg = "";
//            if (orgIdsAndAccountIds == null) {
//                msg += "全平台,第1页:siteId:" + siteId + " (总页数:" + page.getPageTotal() + "),查询人数：" + page.getRecords().size() + " 缓存人数:" + resultccountMap.size();
//            } else {
//            	msg += "指定范围,第1页:siteId:" + siteId + " (总页数:" + page.getPageTotal() + "),查询总人数：" + page.getPageRecords() + " 查询人数:" + page.getRecords().size() + " 缓存人数:" + resultccountMap.size() +
//                		" 指定范围:" + orgIdsAndAccountIds.toString();
//            }
//            taskDetail(taskId, msg);
//
//            //分页查询查找所有人
//            int pageTotal = page.getPageTotal();
//            for (int i = 2; i <= pageTotal; i++) {
//                rrarv.setSiteId(siteId);
////                rrarv.setPageNo(i);
//////                rrarv.setOrgIdsAndAccountIds(orgIdsAndAccountIds);
//////                rrarv.setPageSize(pageSize);
//////                page = reportClient.getRangeAccounts(rrarv);
//                if (page != null && page.getRecords().size() > 0) {
//                    if (learnStu == null) {
//                        learnStu = initStatisticsExamMetadatas(page.getRecords(), findAccountId, resultccountMap, rangeKey, taskId, taskCon);
//                    } else {
//                        initStatisticsExamMetadatas(page.getRecords(), null, resultccountMap, rangeKey, taskId, taskCon);
//                    }
//                    msg = "";
//                    if (orgIdsAndAccountIds == null) {
//                        msg += "全平台,第" + i + "页:siteId:" + siteId + " (总页数:" + page.getPageTotal() + "),查询人数：" + page.getRecords().size() + " 缓存人数:" + resultccountMap.size();
//                    } else {
//                        msg += "指定范围,第" + i + "页:siteId:" + siteId + " (总页数:" + page.getPageTotal() + "),查询总人数：" + page.getPageRecords() + " 查询人数:" + page.getRecords().size() + " 缓存人数:" + resultccountMap.size() +
//                        		" 指定范围:" + orgIdsAndAccountIds.toString();
//                    }
//                    taskDetail(taskId, msg);
//
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            if (siteId == null) {
//                taskDetail(taskId, "获取" + taskCon + "的指定范围Ids:(" + orgIdsAndAccountIds + ") system服务不可用,:" + e.getMessage());
//            } else {
//                taskDetail(taskId, "获取" + taskCon + "的全平台:(" + siteId + ") system服务不可用,:" + e.getMessage());
//            }
//
//            return null;
//        }
//
//        return learnStu;
//    }
//
//    /**
//     * 创建和获取学员学习对象
//     *
//     * @param siteId                  站点ID，为空不缓存学员信息
//     * @param listReportAccountRespVO 查询出的学员
//     * @param resultAccountIds        保存当前查询的学员IDs，每次会清空集合中的记录
//     * @param resultccountMap         保存当前查询的学员信息，每次会清空集合中的记录
//     * @return 当前查询的学员IDs
//     */
//    private StatisticsExamMetadata initStatisticsExamMetadatas(List<ReportAccountRespVO> listReportAccountRespVO, Long findAccountId,
//                                                               Map<Long, StatisticsExamMetadata> resultccountMap, String rangeKey, Long taskId, String taskCon) {
//
//        //查找指定的人
//        StatisticsExamMetadata learnStu = null;
//
//        // 初始化学员学习信息
//        for (ReportAccountRespVO item : listReportAccountRespVO) {
//            Long accountId = item.getUserId();
//            StatisticsExamMetadata stu = null;
//            if (accountMap.get(rangeKey) != null) {
//                stu = accountMap.get(rangeKey).get(accountId);
//            } else {
//                accountMap.put(rangeKey, resultccountMap);
//            }
//
//            if (stu == null) {
//                stu = new StatisticsExamMetadata();
//                stu.setId(null);
//                stu.setAccountId(accountId);
//                stu.setAccountState(item.getStatus());
//                stu.setWorkNum(stu.getWorkNum());
//                stu.setAccountName(item.getUserName());
//                stu.setAccountFullname(item.getUserFullName());
//                stu.setOrgName(item.getOrgName());
//                stu.setAccountOrgId(item.getOrgId());
//                String orgParentNames = null;
//                if (item.getParentOrgNames() != null) {
//                    for (String orgName : item.getParentOrgNames()) {
//                        if (orgParentNames == null) {
//                            orgParentNames = orgName;
//                        } else {
//                            orgParentNames += "/" + orgName;
//                        }
//                    }
//                    stu.setOrgParentNames(orgParentNames);
//                }
//                // 设置实际参加状态，用于实际人数的统计
//                stu.setCanState(1);
//                //设置已参加状态为0（未参加）
//                stu.setJoinState(0);
//                resultccountMap.put(accountId, stu);
//            } else {
//                taskDetail(taskId, "mcz已存在人员信息：" + stu.toString());
//            }
//            if (findAccountId != null && findAccountId.compareTo(accountId) == 0) {
//                learnStu = stu;
//            }
//        }
//        return learnStu;
//    }
//
//    private void insertEmptyExamLearn(Map<Long, StatisticsExamMetadata> resultccountMap, Exam exam,
//                                      List<StatisticsExamMetadata> insertList, Long taskId) {
//        if (insertList != null) {
//            insertList.clear();
//        }
//
//        //获取该考试的学员信息
//        Map<Long, Long> stuMap = statisticsExamMetadataMapper.selectAccountLearnByExamId(exam.getId());
//
//        Iterator<StatisticsExamMetadata> statExams = resultccountMap.values().iterator();
//        StatisticsExamMetadata statExam;
//        while (statExams.hasNext()) {
//            //更新考试信息
//            statExam = statExams.next();
//            statExam.setExamId(exam.getId());
//            statExam.setExamNo(exam.getExamNo());
//            statExam.setExamName(exam.getName());
//            statExam.setExamStartTime(exam.getStartTime());
//            statExam.setExamEndTime(exam.getEndTime());
//            statExam.setExamCreateTime(exam.getCreateTime());
//            statExam.setExamState(exam.getState());
//            //考试的站点信息
//            statExam.setExamCompanyId(exam.getCompanyId());
//            statExam.setExamSiteId(exam.getSiteId());
//            statExam.setExamOrgId(exam.getOrgId());
//
//            if (stuMap == null) {
//                insertList.add(statExam);
//            } else {
//                if (stuMap.get(statExam.getAccountId()) == null) {
//                    insertList.add(statExam);
//                }
//            }
//        }
//        //批量插入
//        if (!CollectionUtils.isEmpty(insertList)) {
//            try {
//                iStatisticsExamMetadataService.insertBatch(insertList);
//                taskDetail(taskId, "批量添加成功" + exam.getName() + "(" + exam.getId() + ")" + "实际添加人数:" + insertList.size() + " 总人数:" + resultccountMap.size());
//            } catch (Exception e) {
//                logger.info("***insert data*********" + JSON.toJSONString(insertList));
//                e.printStackTrace();
//                taskDetail(taskId, "批量添加" + exam.getName() + "(" + exam.getId() + ")" + "数据错误:" + e.getMessage());
//            }
//        }
//    }
//
//    @SuppressWarnings("static-access")
//    private Date addDay(Date date, int num) {
//        Calendar calendar = new GregorianCalendar();
//        calendar.setTime(date);
//        calendar.add(calendar.DATE, num);
//        date = calendar.getTime();
//        return date;
//    }
//
//
//    /**
//     * 测试数据
//     *
//     * @param pageNo
//     * @param pageSize
//     * @return
//     */
//    private PageInfo<ReportAccountRespVO> getTestData(int pageNo, int pageSize) {
//        List<ReportAccountRespVO> l = new ArrayList<ReportAccountRespVO>();
//        ReportAccountRespVO x = new ReportAccountRespVO();
//        x.setUserId(1016273921890463744L);
//        x.setOrgName("xxxx");
//        l.add(x);
//
//        x = new ReportAccountRespVO();
//        x.setOrgName("xxxx");
//        x.setUserId(81754L);
//        l.add(x);
//
//   		/*x = new ReportAccountRespVO();
//   		x.setUserId(989311074940907520L);
//   		l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1004566068968501248L);
//   		l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1004591602767192064L);
//   		l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1004594320063819776L);
//   		l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006492895324151808L);
//   		l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006492995672875008L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006733944520974336L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006734302269939712L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006734588979978240L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1006734878378565632L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1011930094964150272L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1011929942455062528L);l.add(x);
//   		x = new ReportAccountRespVO();
//   		x.setUserId(1011925785505533952L);l.add(x);*/
//
//        //模拟分页
//        int startIndex = (pageNo - 1) * pageSize;
//        int endIndex = pageSize + startIndex;
//        int total = l.size();
//        endIndex = endIndex > total ? total : endIndex;
//        List<ReportAccountRespVO> dataCharts = new ArrayList<ReportAccountRespVO>();
//        for (; startIndex < endIndex; startIndex++) {
//            dataCharts.add(l.get(startIndex));
//        }
//
//        PageInfo<ReportAccountRespVO> page = new PageInfo<ReportAccountRespVO>();
//        page.setRecords(dataCharts);
//        page.setPageTotal(l.size());
//
//        return page;
//    }
//}
