package com.yizhi.application.controller;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.application.domain.TrExamOnlineReadOver;
import com.yizhi.application.export.ReadOnLineExamsExport;
import com.yizhi.application.mapper.TrExamOnlineReadOverMapper;
import com.yizhi.application.service.IExamService;
import com.yizhi.application.service.ITrExamAnswerService;
import com.yizhi.application.service.ITrExamAuthorizeService;
import com.yizhi.application.service.ITrExamOnlineReadOverService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.point.application.feign.PointApiFeignClients;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试阅卷 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Slf4j
@RestController
@RequestMapping("/manage/exam")
public class TrExamOnlineReadOverController {

    private static Logger Log = LoggerFactory.getLogger(TrExamOnlineReadOverController.class);

    @Autowired
    ITrExamOnlineReadOverService iTrExamOnlineReadOverService;

    @Autowired
    private IExamService iExamService;

    @Autowired
    private ITrExamAuthorizeService iTrExamAuthorizeService;

    @Autowired
    private ITrExamAnswerService iTrExamAnswerService;

    @Autowired
    TrExamOnlineReadOverMapper trExamOnlineReadOverMapper;

    @Autowired
    private ReadOnLineExamsExport readOnLineExamsExport;
    @Autowired
    private PointApiFeignClients pointApiFeignClients;

    /**
     * 阅卷列表
     */
    @GetMapping("/marking/list")
    public Map<String, Object> getExamMarkingList(
            @RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
        Map<String, Object> map = null;
        try {
            //只阅卷有问答题的考试，分页查询
            PageHelper.startPage(contextAndPageSizeVO.getPageNo(), contextAndPageSizeVO.getPageSize());
            List<com.yizhi.exam.application.vo.domain.Exam> list = iExamService.examMarkingList(contextAndPageSizeVO); // 实体类数据
            int pageTotal = PageHelper.freeTotal();

            List<ExamDetailsMarkingVO> listVo = null;

            if (!CollectionUtils.isEmpty(list)) {
                listVo = new ArrayList<ExamDetailsMarkingVO>(); // 小的vo类


                //拷贝对象
                ExamDetailsMarkingVO edmv = null;
                for (com.yizhi.exam.application.vo.domain.Exam exam : list) {
                    edmv = new ExamDetailsMarkingVO();
                    BeanUtils.copyProperties(exam, edmv);
                    //初始化人数为0
                    edmv.setCommitExamNum(0);
                    edmv.setIsReadExamNum(0);
                    edmv.setShouldExamNum(0);

                    //获取应考人数
                    if (null != exam.getVisibleRange()) {
                        if (exam.getVisibleRange() == 1) { // 平台用户可见
                            // 得到站点人员id，调用外部接口
                            edmv.setShouldExamNum(0);
                        } else if (exam.getVisibleRange() == 2) { // 指定用户可见
                            edmv.setShouldExamNum(iTrExamAuthorizeService.getShouldExamNum(exam.getId())); // 考试编号id给
                        }
                    }
                    // 已经提交人员
                    edmv.setCommitExamNum(iTrExamAnswerService.getCommitNum(edmv.getId()));
                    // 已阅人数
                    edmv.setIsReadExamNum(iTrExamOnlineReadOverService.getReadNum(edmv.getId()));
                    listVo.add(edmv);
                }

                Map<String, Integer> page = new HashMap<String, Integer>();
                page.put("pageNo", contextAndPageSizeVO.getPageNo());
                page.put("pageSize", contextAndPageSizeVO.getPageSize());
                page.put("pageTotal", pageTotal);
                map = new HashMap<>();
                map.put("list", listVo);
                map.put("page", page);
                return map;
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return map;
        }
        return map;
    }

    /**
     * 答卷列表
     */
    @GetMapping("/marking/student/list")
    public StudentListOutVO selectList(@RequestBody StudentListVO studentListVO) {
        List<ExamOnlineReadOverVo> examOnlineReadOverVos = iTrExamOnlineReadOverService.selectList(studentListVO.getExamId(), studentListVO.getPageNo(), studentListVO.getPageSize(), studentListVO.getUserInfoVOMap());
        Integer count = iTrExamOnlineReadOverService.selectListCount(studentListVO.getExamId(), studentListVO.getUserInfoVOMap());
        StudentListOutVO studentListOutVO = new StudentListOutVO();
        studentListOutVO.setExamOnlineReadOverVos(examOnlineReadOverVos);
        studentListOutVO.setPageTotal(count);
        return studentListOutVO;
    }
	/*public Map<String,Object> getExamMarking(
			@RequestParam(name = "examId", required = true) Long examId,
			@RequestParam(name = "userName", required = false) String userName,
			@RequestParam(name = "name", required = false) String name,
			@RequestParam(name = "depart", required = false) String depart,
			@RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
		Pair<List<ExamOnlineReadOverVo>, Map<String, Integer>> pair = null;
		Map<String,Object> map = null;
		try {
			List<Long> accountIdList = null;// 要根据用户名或姓名或部门从外部接口中获取数据

			PageHelper.startPage(pageNo, pageSize);
			List<TrExamOnlineReadOver> list = iTrExamOnlineReadOverService.list(examId, accountIdList, pageSize, pageNo);
			int pageTotal = PageHelper.freeTotal();

			if(CollectionUtils.isEmpty(list)) {
				return map;
			}
			// 拷贝对象
			ExamOnlineReadOverVo examOnlineReadOverVo = null;
			List<ExamOnlineReadOverVo> listExamOnlineReadOverVo = new ArrayList<ExamOnlineReadOverVo>();
			for (TrExamOnlineReadOver online : list) {
				examOnlineReadOverVo = new ExamOnlineReadOverVo();
				BeanUtils.copyProperties(online, examOnlineReadOverVo);
				listExamOnlineReadOverVo.add(examOnlineReadOverVo);
			}

			Map<String, Integer> page = new HashMap<String, Integer>();
			page.put("pageNo", pageNo);
			page.put("pageSize", pageSize);
			page.put("pageTotal",pageTotal);
			map = new HashMap<String,Object>();
			map.put("list",listExamOnlineReadOverVo);
			map.put("page",page);
			return map;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return map;
		}
	}*/

    /**
     * 批阅答卷
     *
     * @return
     */
    @GetMapping(value = "/marking/student")
    public MarkStudentVO markingStudent(@RequestParam("readOverId") Long readOverId) {
        return iTrExamOnlineReadOverService.markStudent(readOverId);
    }
/*	public PaperInspectionVo  findByExamVo(@RequestParam Long id,@RequestParam("accountName") String accountName){
		PaperInspectionVo paperInspectionVo = null;
		try {
			paperInspectionVo = iTrExamOnlineReadOverService.messageDetail(id,accountName);
			return paperInspectionVo;
		}catch (Exception e) {
			Log.error("", e);
			return paperInspectionVo;
		}
	}*/

    /**
     * 批阅答卷(保存)
     *
     * @return
     */
	/*@PostMapping(value = "/marking/student/save")
	public boolean  insertByFile(@RequestBody PaperInspectionVo paperInspectionVo){
		boolean result = false;
		try {
			result = iTrExamOnlineReadOverService.insertDetail(paperInspectionVo);
			return result;
		}catch (Exception e) {
			Log.error("", e);
			return result;
		}
	}*/
    @PostMapping(value = "/marking/student/save")
    public Integer insertByFile(@RequestBody MarkStudentVO markStudentVO) {
        Map<String, Object> resultMap = new HashMap<>();
        try {
            resultMap = iTrExamOnlineReadOverService.insertMarkStudent(markStudentVO);
            Integer score = (Integer) resultMap.get("score");
            Integer qualifiedScore = (Integer) resultMap.get("qualifiedScore");
            String examId = (String) resultMap.get("examId");
            //考试交卷后根据分数增加积分
            if(score.intValue() >= qualifiedScore.intValue()) {
                log.info("考试合格发放积分:{}", JSONUtil.toJsonStr(resultMap));
                pointApiFeignClients.addPoint(markStudentVO.getAccountId(), "point_exam", examId + "|" + score);
            }
            return score;
        } catch (Exception e) {
            Log.error("", e);
            return 0;
        }
    }

    /**
     * 根据考试ID查询已阅卷人数
     */
    @GetMapping("/read/count")
    public int readCount(@RequestParam("examId") Long examId) {
        try {
            return iTrExamOnlineReadOverService.readCount(examId);
        } catch (Exception e) {
            e.printStackTrace();
            Log.error("查询已阅卷人数失败：", e);
            return 0;
        }
    }

    /**
     * 获取答卷信息
     *
     * @param readOverId
     * @return
     */
    @PostMapping("/read/info")
    public MarkStudentVO getExamOnlineReadOverById(@RequestBody MarkStudentVO markStudentVO) {
        Long examAnswerId = markStudentVO.getExamAnswerId();
        TrExamOnlineReadOver readOver = trExamOnlineReadOverMapper.getExamOnlineReadOverByExamAnswerId(examAnswerId);
        Long examId = readOver.getExamId();
        markStudentVO.setExamId(examId);
        markStudentVO.setAccountId(readOver.getAccountId());
        Exam exam = iExamService.getExam(examId);

        //默认设置不合格
        markStudentVO.setIsQualified(0);
        //计算成绩是否合格
        BigDecimal sumScore = readOver.getSumScore();
        if (sumScore != null && exam != null && exam.getQualifiedScore() != null) {
            if (sumScore.compareTo(new BigDecimal(exam.getQualifiedScore())) != -1) {
                markStudentVO.setIsQualified(1);
            }
        }
        markStudentVO.setSumScore(sumScore);
        markStudentVO.setExamName(exam.getName());
        return markStudentVO;
    }

    /**
     * 管理端阅卷管理添加考试结果导出
     *
     * @param examId
     * @return
     */
    @GetMapping("/read/examExport")
    String studentExamExport(@RequestParam(name = "examId") Long examId) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        com.yizhi.application.domain.Exam examEntity = iExamService.selectById(examId);
        String serialNo = "READ-ONLINE-EXAM-EXPORT" + taskId.toString();
        String taskName =examEntity.getName() + "考试导出结果" + taskId.toString();
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        map.put("res", res);
        map.put("examId", examId);
        readOnLineExamsExport.execute(map, true);
        return taskName;
    }

    /**
     * 阅卷管理加合格人数
     * @param examIds
     * @return
     */
    @GetMapping("/read/getQualifiedNum")
    Map<Long,Integer> getQualifiedNum(@RequestParam("examIds") List<Long> examIds){
        return iTrExamOnlineReadOverService.getQualifiedNum(examIds);
    }
}
