package com.yizhi.application.controller.remote;

import com.yizhi.application.service.IExamService;
import com.yizhi.exam.application.vo.domain.Exam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 考试 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/remote/exam")
public class RemoteExamController {

    private static final Logger LOG = LoggerFactory.getLogger(RemoteExamController.class);

    @Autowired
    private IExamService iExamService;

    @GetMapping("/expireList")
    public List<Exam> getExpireList() {
        return iExamService.getExpireList();
    }
}

