package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 考试
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("exam")
public class Exam extends Model<Exam> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("exam_no")
	private String examNo;

	
	private String name;

	
	private String description;

	
	@TableField("start_time")
	private Date startTime;

	
	@TableField("end_time")
	private Date endTime;

	
	private Integer duration;

	
	@TableField("answer_num")
	private Integer answerNum;

	
	@TableField("exam_num")
	private Integer examNum;

	
	@TableField("qualified_score")
	private Integer qualifiedScore;

	
	@TableField("make_strategy")
	private Integer makeStrategy;

	
	@TableField("sys_make_strategy")
	private Integer sysMakeStrategy;

	
	@TableField("stem_sort")
	private Integer stemSort;

	
	@TableField("type_sort")
	private Integer typeSort;

	
	@TableField("option_sort")
	private Integer optionSort;

	
	@TableField("visible_range")
	private Integer visibleRange;

	
	@TableField("page_mode")
	private Integer pageMode;

	
	@TableField("is_answer_paper")
	private Integer isAnswerPaper;

	
	@TableField("is_score")
	private Integer isScore;

	
	@TableField("is_answer")
	private Integer isAnswer;

	
	@TableField("is_analysis")
	private Integer isAnalysis;

	
	@TableField("is_paperid")
	private Integer isPaperid;

	
	@TableField("is_point")
	private Integer isPoint;

	
	private Integer remind;

	
	private Integer state;

	
	@TableField("old_exam_no")
	private String oldExamNo;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	@TableField("company_id")
	private Long companyId;

	
	@TableField("org_id")
	private Long orgId;

	
	@TableField("site_id")
	private Long siteId;
	
	
	@TableField("training_project_id")
	private Long trainingProjectId;

	
	@TableField("up_time")
	private Date upTime;

	
	@TableField("down_time")
	private Date downTime;

	
	@TableField("library_id")
	private Long libraryId;

	
	@TableField("library_name")
	private String libraryName;

	
	@TableField("keywords")
	private String keywords;

    
    private String image;

	
	@TableField("enable_task")
	private Integer enableTask;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
