package com.yizhi.application.export;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.application.service.IExamService;
import com.yizhi.application.service.ITrExamOnlineReadOverService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.exam.ReadOnLineExamExportVO;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: ding
 * @Date: 2019/06/04
 * @Description:按考试统计查看结果下载
 */
@Component
public class ReadOnLineExamsExport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnLineExamsExport.class);

    @Autowired
    private IExamService iExamService;

    @Autowired
    private ITrExamOnlineReadOverService examOnlineReadOverService;


    @Override
    protected String execute(Map<String, Object> map) {
        String uploadUrl = null;


        Long examId = (Long) map.get("examId");
        RequestContext res = (RequestContext) map.get("res");

        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        Long companyId = res.getCompanyId();
        boolean isAdmin = true;


        Date comitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMddHHmmss");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, comitTime, siteId, companyId);
        working(taskContext);

        List<ReadOnLineExamExportVO> list = null;

        try {
            list = examOnlineReadOverService.studentExamExport(accountId, isAdmin, siteId, examId);
        } catch (Exception e) {
            LOGGER.info("获取数据过程中出现错误", e);
            fail(taskContext, "获取数据过程中出现错误");
        }


        try {

            if (CollectionUtils.isEmpty(list)) {
                success(taskContext, "未找到数据", "");
            }
            com.yizhi.application.domain.Exam examEntity = iExamService.selectById(examId);
            Exam exam = new Exam();
            BeanUtils.copyProperties(examEntity,exam);
            //Exam exam = iExamService.selectById(examId);

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("考试结果明细表");
            XSSFRow row = sheet.createRow(0);

//            HSSFCellStyle cellStyle = wb.createCellStyle();
//            //水平居中
//            cellStyle.setAlignment(HorizontalAlignment.CENTER);
//            //垂直居中
//            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);

//            HSSFFont font = wb.createFont();
//            //字体加粗
//            font.setBold(true);
//            //字体大小14
//            font.setFontHeightInPoints((short) 14);
//
//            cellStyle.setFont(font);


            CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 12);
            sheet.addMergedRegion(cra);
            XSSFCell cell = row.createCell(0);
//            cell.setCellStyle(cellStyle);
            cell.setCellValue(exam.getName() + "考试结果明细表");

            row = sheet.createRow(1);
            cra = new CellRangeAddress(1, 1, 0, 12);
            sheet.addMergedRegion(cra);
            cell = row.createCell(0);
            cell.setCellValue("统计周期：截止：" + sdf.format(new Date()));

            XSSFRow row2 = sheet.createRow(2);
            row2.createCell(0).setCellValue("用户名");
            row2.createCell(1).setCellValue("姓名");
            row2.createCell(2).setCellValue("考试状态");
            row2.createCell(3).setCellValue("交卷状态");
            row2.createCell(4).setCellValue("阅卷状态");
            row2.createCell(5).setCellValue("考试得分");
            row2.createCell(6).setCellValue("考试结果");
            row2.createCell(7).setCellValue("客观题得分");
            row2.createCell(8).setCellValue("主观题得分");
            row2.createCell(9).setCellValue("考试开始时间");
            row2.createCell(10).setCellValue("交卷时间");
            row2.createCell(11).setCellValue("答卷用时");
            row2.createCell(12).setCellValue("所在部门");
            row2.createCell(13).setCellValue("用户状态");

            if (CollectionUtils.isNotEmpty(list)) {
                for (ReadOnLineExamExportVO exportVO : list) {
                    row = sheet.createRow(list.indexOf(exportVO) + 3);
                    row.createCell(0).setCellValue(exportVO.getAccountName() == null ? "--" : exportVO.getAccountName());
                    row.createCell(1).setCellValue(exportVO.getAccountFullName() == null ? "--" : exportVO.getAccountFullName());
                    row.createCell(2).setCellValue(exportVO.getJoinState() == 1 ? "已参加" : "未参加");
                    if (null == exportVO.getSubmitState()) {
                        row.createCell(3).setCellValue("--");
                    } else {
                        row.createCell(3).setCellValue(exportVO.getSubmitState() == 1 ? "已交卷" : "未交卷");
                    }
                    if (null == exportVO.getState()) {
                        row.createCell(4).setCellValue("--");
                    } else {
                        row.createCell(4).setCellValue(exportVO.getState() == 2 ? "已阅卷" : "未阅卷");
                    }
                    row.createCell(5).setCellValue(exportVO.getScore() == null ? "--" : exportVO.getScore().toString());
                    if (null == exportVO.getExamState()) {
                        row.createCell(6).setCellValue("--");
                    } else {
                        row.createCell(6).setCellValue(exportVO.getExamState() == 1 ? "合格" : "不合格");
                    }
                    row.createCell(7).setCellValue(exportVO.getObjectiveScore() == null ? "--" : exportVO.getObjectiveScore().toString());
                    row.createCell(8).setCellValue(exportVO.getSubjectiveScore() == null ? "--" : exportVO.getSubjectiveScore().toString());
                    row.createCell(9).setCellValue(exportVO.getStartTime() == null ? "--" : simpleDateFormat.format(exportVO.getStartTime()));

                   /* 由于数据库部分考试时长是负数，所以对考试时长进行特殊处理 禅道bug-14327
                    友邦考试的数据修正，学员每次答卷时长，基数为30分钟+15分钟（900S）的随机取值
                    同时修改用户的交卷时间，保证开始时间，到结束时间的时长等于生成的时长*/
                    if (exportVO.getDuration() != null && exportVO.getDuration() < 0) {
                        Long userDuration = exportVO.getAccountId() % 900L;
                        Integer duration = 1800 + userDuration.intValue();
                        exportVO.setDuration(duration);
                        if (exportVO.getStartTime() != null) {
                            Date submitAt = new Date(exportVO.getStartTime().getTime() + duration * 10000);
                            exportVO.setFinishTime(submitAt);
                        }
                    }

                    row.createCell(10).setCellValue(exportVO.getFinishTime() == null ? "--" : simpleDateFormat.format(exportVO.getFinishTime()));
                    row.createCell(11).setCellValue(exportVO.getDuration() == null ? "--" : exportVO.getDuration().toString());
                    row.createCell(12).setCellValue(exportVO.getOrgName() == null ? "--" : exportVO.getOrgName());
                    if (null == exportVO.getAccountState()) {
                        exportVO.setAccountState(0);
                    }
                    row.createCell(13).setCellValue(exportVO.getAccountState() == 0 ? "停用" : "启用");
                }
            }


            String fileName = taskName + ".xlsx";
//            String requestPath = "/Users/dingxiaowei/aaa";
            String requestPath = FileConstant.SAVE_PATH;
            File fileDir = new File(requestPath);
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }
            String path = requestPath + "/" + fileName;
            FileOutputStream os = null;
            File file = null;

            try {
                os = new FileOutputStream(path);
                wb.write(os);
                uploadUrl = OssUpload.upload(path, fileName);
                file = new File(path);
                success(taskContext, "成功", uploadUrl);
            } catch (Exception e2) {
                e2.printStackTrace();
                fail(taskContext, "管理端阅卷管理添加考试结果导出,写入过程出现错误");
                LOGGER.error("管理端阅卷管理添加考试结果导出,写入过程出现错误");
            } finally {
                if (os != null) {
                    os.close();
                }
                if (wb != null) {
                    wb.close();
                }
                if (file != null) {
                    file.delete();
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "管理端阅卷管理添加考试结果导出,下载考试结果数据出现错误");
            LOGGER.error("管理端阅卷管理添加考试结果导出,下载考试结果数据出现错误");
        }

        return uploadUrl;
    }
}
