package com.yizhi.application.service;

import java.util.List;

import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.TypeAndCountVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.QuestionLibrary;
import com.yizhi.exam.application.vo.ListLibraryVO;
import com.yizhi.exam.application.vo.QuestionLibraryVO;

/**
 * <p>
 * 题库 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface IQuestionLibraryService extends IService<QuestionLibrary> {

    /**
     * 题库列表
     *
     * @param state
     * @return
     */
    List<QuestionLibrary> getQuestionLibraryList(Integer pageSize, Integer pageNo);

    /**
     * 有多少题库
     *
     * @param companyid
     * @return
     */
    Integer sumNum();

    public boolean insertQuestionLibraryAndTrQuestionLibrarySubjectService(QuestionLibraryVO questionLibraryVO) throws Exception;

    public boolean updateQuestionLibraryAmdTrQuestionLibrarySubjectService(QuestionLibraryVO questionLibraryVO) throws Exception;

    /**
     * 检查题库是否被考试使用
     *
     * @param libraryId
     * @param companyId
     * @param orgId
     * @param siteId
     * @param subjectId
     * @return
     */

    public int libraryState(Long libraryId, Long subjectId);

    /**
     * 检查题目是否被考试使用
     *
     * @param questionId
     * @param companyId
     * @param orgId
     * @param siteId
     * @return
     */
    public int questionState(Long questionId, Long companyId, Long orgId, Long siteId);


    /**
     * 导入题库试题
     *
     * @param multipartFile
     * @return
     */
    Boolean importQuestionLibrary(MultipartFile multipartFile, Long id);

    /**
     * 判断状态
     *
     * @param id
     * @return
     */
    List<ListLibraryVO> getList(ContextAndPageSizeVO contextAndPageSizeVO, List<Long> managerIds);

    Boolean importQuestionLibrary(String file, String fileName, Long id);

    /*
     * 查询题库数量
     * **/
    public int selectLibraryCount(ContextAndPageSizeVO contextAndPageSizeVO, List<Long> managerIds);

    /**
     * 删除
     *
     * @param id
     * @return
     */

    Boolean libDelete(Long id);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    Boolean libDeleteBatch(Long[] ids);

    /*
     * 根据题库ID查询题库信息
     * **/
    QuestionLibraryVO selectQuestionLibraryById(Long id);

    /**
     * 查看题库名称是否为空
     */
    QuestionLibrary nameIsExist(String name);

    /**
     * 查询试题是否被考试使用
     *
     * @param subjectId
     * @return
     */
    int examCountBySubjectId(Long subjectId);

    List<TypeAndCountVo> getTypeAndCount(Long examId, Long libraryId);
}

