package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.domain.TrExamAnswerQuestionRes;
import com.yizhi.application.domain.TrExamAnswerQuestionResMa;
import com.yizhi.exam.application.vo.ExamCountByUserVO;
import com.yizhi.exam.application.vo.ExamQuestionSubjectVo;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.application.mapper.ExamReportMapper;
import com.yizhi.application.service.IExamReportService;
import com.yizhi.application.service.IStatisticsExamMetadataService;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import com.yizhi.system.application.vo.ReportAccountRespInManageVO;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import com.yizhi.exam.application.vo.report.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试统计服务实现类
 * </p>
 *
 * @author mei
 */
@Service
public class ExamReportServiceImpl implements IExamReportService {

    private static Logger logger = LoggerFactory.getLogger(ExamReportServiceImpl.class);

    @Autowired
    ExamReportMapper examReportMapper;

    @Autowired
    IStatisticsExamMetadataService statisticsExamMetadataService;

    @Autowired
    ReportClient reportClient;

    @Override
    public Integer getMaxScoreeExamAnswerCount(Map<String, Object> paramMaps) {
        return examReportMapper.selectMaxScoreeExamAnswerCount(paramMaps);
    }

    @Override
    public List<TrExamAnswer> getMaxScoreeExamAnswerInfo(Map<String, Object> paramMaps, Integer pageNo,
                                                         Integer pageSize) {
        Page<TrExamAnswer> page = new Page<>(pageNo, pageSize);
        return examReportMapper.selectMaxScoreeExamAnswerInfo(paramMaps, page);
    }

    @Override
    public Integer selectExamAnswerSubjectByAccountIdCount(Long accountId, Long answerId) {
        return examReportMapper.selectExamAnswerSubjectByAccountIdCount(accountId, answerId);
    }

    @Override
    public List<ExamQuestionSubjectVo> getExamAnswerSubjectByAccountId(Long accountId, Long answerId,
                                                                       Integer pageNo, Integer pageSize) {
        return examReportMapper.selectExamAnswerSubjectByAccountId(accountId, answerId, pageNo, pageSize);
    }

    @Override
    public List<TrExamAnswerQuestionRes> getExamAnswerSubjectOption(Long answerId, Long answerQuestionId, Long subjectId) {
        return examReportMapper.selectExamAnswerSubjectOption(answerId, answerQuestionId, subjectId);
    }

    @Override
    public TrExamAnswerQuestionResMa getExamAnswerSubjectOptionMain(Long answerId, Long answerQuestionId) {
        return examReportMapper.selectExamAnswerSubjectOptionMain(answerId, answerQuestionId);
    }

    @Override
    public Page<ReportExamVO> getExamGroup(ReportExamParam reportExamParam) {

        //先分页查询出要统计的考试ID
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", "examGroup");
        paramMap.put("companyId", reportExamParam.getCompanyId());
        List<Long> siteIds = null;
        if (reportExamParam.getSiteId() != null) {
            siteIds = new ArrayList<Long>();
            siteIds.add(reportExamParam.getSiteId());
        }
        paramMap.put("siteIds", siteIds);
        paramMap.put("orgIds", reportExamParam.getOrgIds());
        paramMap.put("startTime", reportExamParam.getStartTime());
        paramMap.put("endTime", reportExamParam.getEndTime());
        paramMap.put("examNameLike", reportExamParam.getExamNameLike());
        Page<Long> examIds = statisticsExamMetadataService.selectAccountLearnList(paramMap,
                reportExamParam.getPageNo(), reportExamParam.getPageSize());
        if (examIds == null || examIds.getRecords() == null || examIds.getRecords().size() == 0) {
            return null;
        }

        //拿着这些考试ID进行统计
        List<ReportExamVO> exams = examReportMapper.getExamGroup(reportExamParam, examIds.getRecords());
        Page<ReportExamVO> page = new Page<ReportExamVO>(reportExamParam.getPageNo(), reportExamParam.getPageSize());
        page.setRecords(exams);
        page.setTotal(examIds.getTotal());

        return page;
    }

    @Override
    public Page<ReportExamAccountVO> getExamAccountGroup(ExamCountByUserVO vo) {
        //先分页查询出要统计的学员ID
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", "accountGroup");
        paramMap.put("companyId", vo.getCompanyId());
        List<Long> siteIds = null;
        if (vo.getSiteId() != null) {
            siteIds = new ArrayList<Long>();
            siteIds.add(vo.getSiteId());
        }
        paramMap.put("siteIds", siteIds);
        paramMap.put("orgIds", vo.getOrgIds());
        paramMap.put("startTime", vo.getStartTime());
        paramMap.put("endTime", vo.getEndTime());
        paramMap.put("orgNameLike", vo.getOrgNameLike());
        paramMap.put("accountNameLike", vo.getAccountNameLike());

        Page<Long> accountIds = statisticsExamMetadataService.selectAccountLearnList(paramMap,
                vo.getPageNo(), vo.getPageSize());
        if (accountIds == null || accountIds.getRecords() == null || accountIds.getRecords().size() == 0) {
            return null;
        }

        //拿着这些学员ID进行统计
        List<ReportExamAccountVO> accounts = examReportMapper.getExamAccountGroup(vo, accountIds.getRecords());
        Page<ReportExamAccountVO> page = new Page<ReportExamAccountVO>(vo.getPageNo(), vo.getPageSize());
        page.setRecords(accounts);
        page.setTotal(accountIds.getTotal());

        return page;
    }

    @Override
    public Page<ReportExamAccountViewVo> getExamAccountGroupView(Long accountId, String startTime,
                                                                 String endTime, String examNameLike, Integer pageNo, Integer pageSize) {
        Page<ReportExamAccountViewVo> page = new Page<>(pageNo, pageSize);
        List<ReportExamAccountViewVo> list = examReportMapper.getExamAccountGroupView(accountId, startTime, endTime, examNameLike,
                page);
        page.setRecords(list);
        //page.setTotal(examReportMapper.getExamAccountGroupViewCount(accountId, startTime, endTime));
        return page;
        /*return page.setRecords(examReportMapper.getExamAccountGroupView(accountId, startTime, endTime, page));*/
    }

    @Override
    public Page<ReportExamAccountsViewVo> getExamAndAccountGroup(ExamCountByUserVO vo) {
        Page<ReportExamAccountsViewVo> page = new Page<>(vo.getPageNo(), vo.getPageSize());
        page.setRecords(examReportMapper.getExamAndAccountGroup(vo, page));
        return page;
    }

    @Override
    public Page<ReportExamAccountsViewVo> getExamAndAccountGroupView(Long examId,
                                                                     Long siteId,
                                                                     Long accountId,
                                                                     boolean isAdmin,
                                                                     String accountNameLike,
                                                                     String orgNameLike,
                                                                     String startTime,
                                                                     String endTime,
                                                                     int pageNo,
                                                                     int pageSize) {
        //获取合格分
        BigDecimal qualifiledScore = null;
        Integer score = examReportMapper.getQualifieldScore(examId);
        if (null != score) {
            qualifiledScore = new BigDecimal(score);
        }
        //获取学员信息
        logger.info("siteId:" + siteId);

        List<ReportAccountRespVO> accountList = null;
        if (isAdmin) {
            ReportRangeAccountReqVO reportRangeAccountReqVO = new ReportRangeAccountReqVO();
            reportRangeAccountReqVO.setSiteId(siteId);
            accountList = reportClient.getRangeAccounts(reportRangeAccountReqVO);
        } else {
            HQAccountInManageParam hqAccountInManageParam = new HQAccountInManageParam();
            hqAccountInManageParam.setAccountId(accountId);
            hqAccountInManageParam.setSiteId(siteId);
            hqAccountInManageParam.setModuleType(AuthzConstant.moduleType.statistics_exam);
            ReportAccountRespInManageVO reportAccountRespInManageVO = reportClient.getRangeAccountsInManage(hqAccountInManageParam);
            if (null != reportAccountRespInManageVO) {
                if (reportAccountRespInManageVO.getIsAdmin()){
                    ReportRangeAccountReqVO reportRangeAccountReqVO = new ReportRangeAccountReqVO();
                    reportRangeAccountReqVO.setSiteId(siteId);
                    accountList = reportClient.getRangeAccounts(reportRangeAccountReqVO);
                }else {
                    accountList = reportAccountRespInManageVO.getList();
                }
            }
        }
        List<Long> accountIds = new ArrayList<>();

        Map<Long, ReportAccountRespVO> accountMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(accountList)) {
            for (ReportAccountRespVO reportAccountRespVO : accountList) {
                accountIds.add(reportAccountRespVO.getUserId());
                accountMap.put(reportAccountRespVO.getUserId(), reportAccountRespVO);
            }
        }

        List<ReportExamAccountsViewVo> resultList = new ArrayList<>();

        Page<ReportExamAccountsViewVo> resultPage = new Page<>(pageNo, pageSize);

        Page<ReportExamAccountsViewVo> page = new Page<>(pageNo, pageSize);
        List<ReportExamAccountsViewVo> list = examReportMapper.getExamAndAccountGroupView(accountIds, examId, startTime, endTime, page);
        if (!CollectionUtils.isEmpty(list)) {
            for (ReportExamAccountsViewVo listVo : list) {
                ReportAccountRespVO account = accountMap.get(listVo.getAccountId());

                if (null == account) {
                    account = new ReportAccountRespVO();
                }

                listVo.setAccountName( account.getUserName());
                listVo.setAccountFullName(account.getUserFullName());
                listVo.setOrgName(account.getOrgName());
                listVo.setAccountState(account.getStatus());
                listVo.setOrgId(account.getOrgId());
                if (listVo.getState() == 2) {
                    if (qualifiledScore != null && listVo.getScore().compareTo(qualifiledScore) >= 0) {
                        listVo.setExamState(1);
                    } else {
                        listVo.setExamState(0);
                    }
                } else {
                    listVo.setExamState(2);
                }
                resultList.add(listVo);
            }
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            resultPage.setRecords(resultList);
            resultPage.setTotal(page.getTotal());
        }

        return resultPage;

    }


    @Override
    public List<ReportExamChartsVo> getExamScoreGroupView(Long examId, String startTime, String endTime) {
        BigDecimal minScore = null;
        BigDecimal maxScore = null;
        List<ReportExamChartsVo> charts = new ArrayList<ReportExamChartsVo>();
        ReportExamChartsVo chart = null;
        List<Map<String, Object>> scores = examReportMapper.getExamScoreLevel(examId);
        Object score = null;
        if (charts != null) {
            for (Map<String, Object> item : scores) {
                chart = new ReportExamChartsVo();
                score = item.get("minScore");
                minScore = new BigDecimal(score.toString());
                score = item.get("maxScore");
                maxScore = new BigDecimal(score.toString());
                Integer count = examReportMapper.getExamScoreTotal(examId, minScore, maxScore, startTime, endTime);
                if (count == null) {
                    count = 0;
                }
                chart.setMaxScore((Integer) item.get("maxScore"));
                chart.setMinScore((Integer) item.get("minScore"));
                chart.setTotalAccount(count);
                charts.add(chart);
            }
        }

        return charts;
    }

    @Override
    public List<ReportExamSubjectChartsVotr> getExamSubGroupView(Long examId) {
        return examReportMapper.getExamSubGroupView(examId);
    }

    @Override
    public Map<Long, Map<String, Object>> getExamAnswerSubjectCountInfo(List<TrExamAnswer> answerIds, Integer isRight) {
        return examReportMapper.getExamAnswerSubjectCountInfo(answerIds, isRight);
    }

    @Override
    public Integer getWrongCount(Long answerId) {
        return examReportMapper.getWrongCount(answerId);
    }

    @Override
    public Integer getQuestionCount(Long answerId) {
        return examReportMapper.getQuestionCount(answerId);
    }

    @Override
    public List<Long> getResMaRightId(Long answerId, Long examId) {
        return examReportMapper.getResMaRightId(answerId, examId);
    }

    @Override
    public List<Long> getWrongIds(Long answerId) {
        return examReportMapper.getWrongIds(answerId);
    }

    @Override
    public List<Long> getQuestionIds(Long answerId) {
        return examReportMapper.getQuestionIds(answerId);
    }
}
