package com.yizhi.application.service.impl;


import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.*;
import com.yizhi.exam.application.enums.EvenType;
import com.yizhi.application.mapper.TrExamAnswerMapper;
import com.yizhi.application.mapper.TrExamOnlineReadOverMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.*;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.application.util.ExamEvenSendMessage;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ReadOnLineExamExportVO;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import com.yizhi.system.application.vo.ReportAccountRespInManageVO;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;
import java.util.stream.Collectors;


/**
 * <p>
 * 考试阅卷 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamOnlineReadOverServiceImpl extends ServiceImpl<TrExamOnlineReadOverMapper, TrExamOnlineReadOver>
        implements ITrExamOnlineReadOverService {

    private static Logger Log = LoggerFactory.getLogger(TrExamOnlineReadOverServiceImpl.class);

    @Autowired
    IdGenerator idGenerator;

    @Autowired
    TrExamAnswerMapper trExamAnswerMapper;

    @Autowired
    TrExamOnlineReadOverMapper trExamOnlineReadOverMapper;

    @Autowired
    TrExamOnlineReadOverMapper examOnlineReadOverMapper;

    @Autowired
    ITrExamAnswerQuestionService iTrExamAnswerQuestionService;

    @Autowired
    ITrExamPointService iTrExamPointService;

    @Autowired
    ReportClient reportClient;

    @Autowired
    IExamService examService;

    @Autowired
    ITrExamAuthorizeService examAuthorizeService;

    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ExamEvenSendMessage examEvenSendMessage;

    @Transactional
    public Boolean insertDetail(PaperInspectionVo paperInspectionVo) {
        TrExamOnlineReadOver trExamOnlineReadOver = new TrExamOnlineReadOver();
        TrExamAnswerQuestion trExamAnswerQuestion = null;
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        Date dateTime = new Date(System.currentTimeMillis());
        BeanUtils.copyProperties(paperInspectionVo, trExamOnlineReadOver);
        if (trExamOnlineReadOver.getReadOverId() == null) {
            trExamOnlineReadOver.setReadOverId(idGenerator.generate());
            trExamOnlineReadOver.setSumNum(1);
        }
        trExamOnlineReadOver.setExamAnswerId(paperInspectionVo.getId());
        if (trExamOnlineReadOver.getSumNum() == 1) {
            trExamOnlineReadOver.setFirstReadOveTime(dateTime);
        }
        trExamOnlineReadOver.setReadOveTime(dateTime);
        trExamOnlineReadOver.setCreateById(paperInspectionVo.getAccountId());
        trExamOnlineReadOver.setCreateByName(paperInspectionVo.getAccountName());
        trExamOnlineReadOver.setUpdateById(paperInspectionVo.getAccountId());
        trExamOnlineReadOver.setUpdateByName(paperInspectionVo.getAccountName());
        this.insertOrUpdate(trExamOnlineReadOver);
        List<ExamQuestionSubjectVo> list = paperInspectionVo.getListExam();
        for (int i = 0; i < list.size(); i++) {
            trExamAnswerQuestion = new TrExamAnswerQuestion();
            BeanUtils.copyProperties(list.get(i), trExamAnswerQuestion);
            if (list.get(i).getId() == null) {
                trExamAnswerQuestion.setId(idGenerator.generate());
            }
            trExamAnswerQuestion.setScore(list.get(i).getScore());
            trExamAnswerQuestion.setAccountId(paperInspectionVo.getAccountId());
            trExamAnswerQuestion.setCreateById(paperInspectionVo.getAccountId());
            trExamAnswerQuestion.setCreateByName(paperInspectionVo.getAccountName());
            trExamAnswerQuestion.setUpdateById(paperInspectionVo.getAccountId());
            trExamAnswerQuestion.setUpdateByName(paperInspectionVo.getAccountName());
            iTrExamAnswerQuestionService.insertOrUpdate(trExamAnswerQuestion);
        }
        BeanUtils.copyProperties(paperInspectionVo, trExamAnswer);
        trExamAnswer.setCreateById(paperInspectionVo.getAccountId());
        trExamAnswer.setCreateByName(paperInspectionVo.getAccountName());
        trExamAnswer.setUpdateById(paperInspectionVo.getAccountId());
        trExamAnswer.setUpdateByName(paperInspectionVo.getAccountName());
        trExamAnswerMapper.updateById(trExamAnswer);
        return true;
    }

    public PaperInspectionVo messageDetail(Long id, String accountName) {
        PaperInspectionVo paperInspectionVo = trExamOnlineReadOverMapper.findByParam(id);
        if (paperInspectionVo == null) {
            paperInspectionVo = new PaperInspectionVo();
        }
        paperInspectionVo.setListExam(trExamOnlineReadOverMapper.findQuestionByParam(id));
        paperInspectionVo.setAccountName(accountName);
        return paperInspectionVo;
    }


    public List<TrExamOnlineReadOver> getResults(Long examId) {
        TrExamOnlineReadOver trExamOnlineReadOver = new TrExamOnlineReadOver();
        trExamOnlineReadOver.setExamId(examId);
        EntityWrapper<TrExamOnlineReadOver> wrapper = new EntityWrapper<TrExamOnlineReadOver>(trExamOnlineReadOver);
        return this.selectList(wrapper);
    }

    /**
     * 没有阅卷的人数
     */
    public Integer getNoReadNum(Long examid) {
        // TODO Auto-generated method stub
        EntityWrapper<TrExamOnlineReadOver> wrapper = new EntityWrapper<TrExamOnlineReadOver>();
        wrapper.like("state", "0");
        wrapper.like("exam_id", Long.toString(examid));
        return this.selectCount(wrapper);
    }

    /**
     * 阅卷列表
     */
    public List<TrExamOnlineReadOver> list(Long examId, List<Long> accountIdList, Integer pageSize, Integer pageNo) {
        // TODO Auto-generated method stub
        Integer start = (pageNo - 1) * pageSize;
        Integer end = pageNo * pageSize;
        return examOnlineReadOverMapper.listTrExamOnlineReadOver(examId, accountIdList, start, end);
    }


    /**
     * 数量
     */
    public Integer sumNum(Long examId, List<Long> accountIdList, Integer pageSize, Integer pageNo) {
        // TODO Auto-generated method stub
        Integer start = (pageNo - 1) * pageSize;
        Integer end = pageNo * pageSize;
        return examOnlineReadOverMapper.likeListSum(examId, accountIdList, start, end);
    }

    /**
     * 已经阅卷的人数
     */
    @Override
    public Integer getReadNum(Long examid) {
        EntityWrapper<TrExamOnlineReadOver> wrapper = new EntityWrapper<TrExamOnlineReadOver>();
        wrapper.like("state", "0");
        wrapper.like("exam_id", Long.toString(examid));
        return this.selectCount(wrapper);
    }

    @Override
    public List<ExamOnlineReadOverVo> selectList(Long examId, Integer pageNo, Integer pageSize, Map<Long, UserInfoVO> userInfoVOMap) {
        int start = (pageNo - 1) * pageSize;
        RequestContext res = ContextHolder.get();
        List<Long> accountIds = null;
        if (!res.isAdmin()) {
            HQAccountInManageParam manageParam = new HQAccountInManageParam();
            manageParam.setModuleType(AuthzConstant.moduleType.exam);
            manageParam.setAccountId(res.getAccountId());
            manageParam.setSiteId(res.getSiteId());
            ReportAccountRespInManageVO respInManageVO = reportClient.getRangeAccountsInManage(manageParam);
            if (!respInManageVO.getIsAdmin()) {
                List<ReportAccountRespVO> accounts = respInManageVO.getList();
                if (CollectionUtils.isNotEmpty(accounts)){
                    accountIds = accounts.stream().map(ReportAccountRespVO :: getUserId).collect(Collectors.toList());
                }
            }
        }

        List<ExamOnlineReadOverVo> examOnlineReadOverVos = examOnlineReadOverMapper.selectList(accountIds, examId, start, pageSize, userInfoVOMap);
        return examOnlineReadOverVos;
    }

    @Override
    public Integer selectListCount(Long examId, Map<Long, UserInfoVO> userInfoVOMap) {
        RequestContext res = ContextHolder.get();
        List<Long> accountIds = null;
        if (!res.isAdmin()) {
            HQAccountInManageParam manageParam = new HQAccountInManageParam();
            manageParam.setModuleType(AuthzConstant.moduleType.exam);
            manageParam.setAccountId(res.getAccountId());
            manageParam.setSiteId(res.getSiteId());
            ReportAccountRespInManageVO respInManageVO = reportClient.getRangeAccountsInManage(manageParam);
            if (!respInManageVO.getIsAdmin()) {
                List<ReportAccountRespVO> accounts = respInManageVO.getList();
                if (CollectionUtils.isNotEmpty(accounts)){
                    accountIds = accounts.stream().map(ReportAccountRespVO :: getUserId).collect(Collectors.toList());
                }
            }
        }
        return examOnlineReadOverMapper.selectListCount(accountIds, examId, userInfoVOMap);
    }

    @Override
    public MarkStudentVO markStudent(Long id) {
//        MarkStudentVO markStudentVO = examOnlineReadOverMapper.selectReadOverById(id);

        MarkStudentVO markStudentVO = new MarkStudentVO();
        Connection conn = null;
        Statement st = null;

        ResultSet rs = null;
        StringBuilder sql = new StringBuilder("");

        sql.append("SELECT a.read_over_id AS readOverId,a.sum_num AS sumNum,b.name AS ")
                .append("examName,a.objective_score AS objectiveScore,a.subjective_score AS subjectiveScore, ")
                .append("a.sum_score AS sumScore, ")
                .append("CASE WHEN a.state = 2 THEN CASE WHEN (a.sum_score>=b.qualified_score) ")
                .append("THEN '1' ELSE '0' END END AS isQualified, ")
                .append("a.account_id AS accountId,exam_answer_id as examAnswerId ")
                .append("FROM tr_exam_online_read_over a ")
                .append("LEFT JOIN exam b ON b.id = a.exam_id ")
                .append("where read_over_id =").append(id);

        try {
            try {
                conn = this.sqlSessionBatch().getConnection();
                st = conn.createStatement();
                Log.info("执行的sql={}", sql.toString());
                rs = st.executeQuery(sql.toString());
                while (rs.next()) {
                    markStudentVO.setReadOverId(rs.getLong("readOverId"));
                    markStudentVO.setExamName(rs.getString("examName"));
                    markStudentVO.setObjectiveScore(rs.getBigDecimal("objectiveScore"));
                    markStudentVO.setSubjectiveScore(rs.getBigDecimal("subjectiveScore"));
                    markStudentVO.setSumScore(rs.getBigDecimal("sumScore"));
                    markStudentVO.setIsQualified(rs.getInt("isQualified"));
                    markStudentVO.setAccountId(rs.getLong("accountId"));
                    markStudentVO.setExamAnswerId(rs.getLong("examAnswerId"));
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (null != rs) {
                    rs.close();
                }
                if (null != st) {
                    st.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
            Log.info("阅卷获取信息创建jdbc连接过程中,获取列表信息出现异常");
        }

        if (null != markStudentVO) {
            List<MarkStudentQuestionVO> markStudentQuestionVOS = examOnlineReadOverMapper.selectQuestionByAnswerId(markStudentVO.getReadOverId());
            markStudentVO.setMarkStudentQuestionVOS(markStudentQuestionVOS);
        }
        return markStudentVO;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Map<String, Object> insertMarkStudent(MarkStudentVO markStudentVO) {
        Map<String, Object> result = new HashMap<>();
        Date createTime = new Date();
        BigDecimal score = new BigDecimal(0);
        TrExamAnswerQuestion trExamAnswerQuestion;
        List<TrExamAnswerQuestion> trExamAnswerQuestions = new ArrayList<TrExamAnswerQuestion>();
        for (MarkStudentQuestionVO markStudentQuestionVO : markStudentVO.getMarkStudentQuestionVOS()) {
            trExamAnswerQuestion = new TrExamAnswerQuestion();
            trExamAnswerQuestion.setId(markStudentQuestionVO.getQuestionId());
            trExamAnswerQuestion.setScore(markStudentQuestionVO.getScore());
            trExamAnswerQuestion.setUpdateById(markStudentVO.getReadAccountId());
            trExamAnswerQuestion.setUpdateByName(markStudentVO.getReadAccountName());
            trExamAnswerQuestion.setUpdateTime(createTime);
            trExamAnswerQuestions.add(trExamAnswerQuestion);
            score = score.add(markStudentQuestionVO.getScore());
        }
        boolean questionResult = iTrExamAnswerQuestionService.updateBatchById(trExamAnswerQuestions);
        TrExamOnlineReadOver trExamOnlineReadOver = trExamOnlineReadOverMapper.getExamOnlineReadOverByExamAnswerId(markStudentVO.getExamAnswerId());
        if (trExamOnlineReadOver == null) {
            return null;
        }
        boolean overResult;
        if (questionResult) {
            //更新首次阅卷时间
            if (trExamOnlineReadOver.getFirstReadOveTime() == null) {
                trExamOnlineReadOver.setFirstReadOveTime(createTime);
            }
            trExamOnlineReadOver.setReadOverId(trExamOnlineReadOver.getReadOverId());
            trExamOnlineReadOver.setSubjectiveScore(score);
            trExamOnlineReadOver.setObjectiveScore(markStudentVO.getObjectiveScore());
            BigDecimal sumScore = score.add(markStudentVO.getObjectiveScore());
            trExamOnlineReadOver.setSumScore(sumScore);
            trExamOnlineReadOver.setReadOveTime(createTime);
            trExamOnlineReadOver.setUpdateById(markStudentVO.getReadAccountId());
            trExamOnlineReadOver.setUpdateByName(markStudentVO.getReadAccountName());
            trExamOnlineReadOver.setUpdateTime(createTime);
            Integer sumNum = trExamOnlineReadOver.getSumNum();
            sumNum = sumNum == null ? 0 : sumNum;
            trExamOnlineReadOver.setSumNum(sumNum + 1);
            //已完成阅卷，修改阅卷保存,状态还是已未完成阅卷（2）
            if (markStudentVO.getType() == 0 && trExamOnlineReadOver.getState() == 2) {
                trExamOnlineReadOver.setState(2);
            } else if (markStudentVO.getType() == 1) {
                //type为1，修改状态为完成阅卷(2)
                trExamOnlineReadOver.setState(2);
            } else {
                //其他保存,状态都为3
                trExamOnlineReadOver.setState(3);
            }
        }
        overResult = this.updateById(trExamOnlineReadOver);
        Integer point = null;
        if (overResult) {
            point = 0;
        }

        //判断是否是完成阅卷
        Integer type = markStudentVO.getType();
        type = type == null ? 0 : type;
        if (overResult && type == 1) {
            BigDecimal totalScore = trExamOnlineReadOver.getSumScore();
            point = totalScore.intValue();
            result.put("score", totalScore.intValue());
            //计算考试积分
//            List<TrExamPointVO> trExamPointVOS = iTrExamPointService.listTrExamPoint(trExamOnlineReadOver.getExamId());
//            for (TrExamPointVO trExamPointVO : trExamPointVOS) {
//                BigDecimal minScore = new BigDecimal(trExamPointVO.getMinScore());
//                BigDecimal maxScore = new BigDecimal(trExamPointVO.getMaxScore());
//                //a = -1,表示bigdemical小于bigdemical2；a = 0 表示bigdemical等于bigdemical2；a = 1表示bigdemical大于bigdemical2；
//                Integer a = totalScore.compareTo(minScore);
//                Integer b = totalScore.compareTo(maxScore);
//                if (a >= 0 && b < 1) {
//                    point = trExamPointVO.getPoint();
//                    break;
//                }
//            }

            //完成阅卷了，更新答卷状态
            TrExamAnswer trExamAnswer = new TrExamAnswer();
            trExamAnswer.setId(markStudentVO.getExamAnswerId());
            trExamAnswer.setUpdateById(markStudentVO.getReadAccountId());
            trExamAnswer.setUpdateByName(markStudentVO.getReadAccountName());
            trExamAnswer.setUpdateTime(createTime);
            trExamAnswer.setState(2);
            trExamAnswer.setScore(totalScore);
            trExamAnswerMapper.updateById(trExamAnswer);

            //阅卷完成发消息
            try {
                TrExamAnswer trExamAnswer1 = trExamAnswerMapper.selectById(markStudentVO.getExamAnswerId());
                if (trExamAnswer1 == null) {
                    return result;
                }
                Exam exam = examService.selectById(trExamAnswer1.getExamId());
                if (exam != null) {

                    result.put("examId", exam.getId().toString());
                    result.put("qualifiedScore", exam.getQualifiedScore());

                    if (trExamAnswer1.getAccountId() != null) {
                        taskExecutor.asynExecute(new AbstractTaskHandler() {
                            @Override
                            public void handle() {
                                com.yizhi.exam.application.vo.domain.Exam examVo = new com.yizhi.exam.application.vo.domain.Exam();
                                BeanUtils.copyProperties(exam,examVo);
                                examEvenSendMessage.evenSendMessage(examVo, trExamAnswer1.getAccountId(), EvenType.EXAM_AUDIT_FINISH, totalScore.doubleValue());
                            }
                        });
                    }
                } else {
                    Log.info("exam为空！！！");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            Log.info("手动阅卷完成，考试得分返回结果result:{}", JSONUtil.toJsonStr(result));
            return result;
        } else {
            Log.info("考试:{} 无积分发放", trExamOnlineReadOver.getExamId());
        }
        return result;
    }

    /**
     * 根据考试ID查询已阅卷人数
     */
    @Override
    public int readCount(Long examId) {

        return trExamOnlineReadOverMapper.getReadCount(examId);
    }

    @Override
    public List<ReadOnLineExamExportVO> studentExamExport(Long accountId, boolean isAdmin, Long siteId, Long examId) {

        List<Long> accountIds = new ArrayList<>();
        Map<Long, ReportAccountRespVO> accountMap = new HashMap<>();

        Exam exam = examService.selectById(examId);
        List<Long> relationAccountIds = null;
        List<Long> relationOrgIds = null;
        //如果是指定范围找出指定范围的部门或者用户id
        if (exam.getVisibleRange() == 2) {
            relationAccountIds = new ArrayList<>();
            relationOrgIds = new ArrayList<>();
            TrExamAuthorize trExamAuthorize = new TrExamAuthorize();
            trExamAuthorize.setExamId(examId);
            trExamAuthorize.setState(1);
            List<TrExamAuthorize> trExamAuthorizes = examAuthorizeService.selectList(new EntityWrapper<>(trExamAuthorize));
            if (CollectionUtils.isNotEmpty(trExamAuthorizes)) {
                for (TrExamAuthorize trExamAuthorize1 : trExamAuthorizes) {
                    if (trExamAuthorize1.getType() == 1) {
                        relationOrgIds.add(trExamAuthorize1.getRelationId());
                    } else if (trExamAuthorize1.getType() == 2) {
                        relationAccountIds.add(trExamAuthorize1.getRelationId());
                    }
                }
            } else {
                return null;
            }
        }
        if (null == exam) {
            return null;
        }

        boolean isUseAccountIds = false;
        if (isAdmin) {
            //管理员
            ReportRangeAccountReqVO reqVO = new ReportRangeAccountReqVO();
            //如果是指定范围放入指定的部门或者用户id
            if (exam.getVisibleRange() == 2) {
                isUseAccountIds = true;
                if (CollectionUtils.isNotEmpty(relationAccountIds)) {
                    reqVO.setAccountIds(relationAccountIds);
                }
                if (CollectionUtils.isNotEmpty(relationOrgIds)) {
                    reqVO.setOrgIds(relationOrgIds);
                }
            }
            reqVO.setSiteId(siteId);
            List<ReportAccountRespVO> accounts = reportClient.getRangeAccounts(reqVO);
            //将用户id拿出并将用户信息放入map中
            if (CollectionUtils.isNotEmpty(accounts)) {
                for (ReportAccountRespVO accountRespVO : accounts) {
                    accountIds.add(accountRespVO.getUserId());
                    accountMap.put(accountRespVO.getUserId(), accountRespVO);
                }
            } else {
                return null;
            }
        } else {
            isUseAccountIds = true;
            List<Long> relationIds = null;
            //一般管理员
            if (exam.getVisibleRange() == 2) {
                ReportRangeAccountReqVO reqVO = new ReportRangeAccountReqVO();
                if (CollectionUtils.isNotEmpty(relationAccountIds)) {
                    reqVO.setAccountIds(relationAccountIds);
                }
                if (CollectionUtils.isNotEmpty(relationOrgIds)) {
                    reqVO.setOrgIds(relationOrgIds);
                }
                reqVO.setSiteId(siteId);
                List<ReportAccountRespVO> accounts = reportClient.getRangeAccounts(reqVO);
                if (CollectionUtils.isNotEmpty(accounts)) {
                    relationIds = accounts.stream().map(ReportAccountRespVO::getUserId).collect(Collectors.toList());
                } else {
                    return null;
                }
            }
            //查找出管辖区下所有的用户
            HQAccountInManageParam reqVO = new HQAccountInManageParam();
            reqVO.setAccountId(accountId);
            reqVO.setSiteId(siteId);
            reqVO.setModuleType(AuthzConstant.moduleType.exam);
            ReportAccountRespInManageVO respInManageVO = reportClient.getRangeAccountsInManage(reqVO);
            //遍历管辖区用户,如果是指定范围还要与指定用户取次
            if (null != respInManageVO) {
                if (!respInManageVO.getIsAdmin()) {
                    for (ReportAccountRespVO respVO : respInManageVO.getList()) {
                        if (relationIds != null) {
                            if (relationIds.contains(respVO.getUserId())) {
                                accountIds.add(respVO.getUserId());
                                accountMap.put(respVO.getUserId(), respVO);
                            } else {
                                continue;
                            }
                        } else {
                            accountIds.add(respVO.getUserId());
                            accountMap.put(respVO.getUserId(), respVO);
                        }
                    }
                } else {
                    //授权根目录当作管理员处理
                    ReportRangeAccountReqVO reqVO1 = new ReportRangeAccountReqVO();
                    //如果是指定范围放入指定的部门或者用户id
                    if (exam.getVisibleRange() == 2) {
                        if (CollectionUtils.isNotEmpty(relationAccountIds)) {
                            reqVO1.setAccountIds(relationAccountIds);
                        }
                        if (CollectionUtils.isNotEmpty(relationOrgIds)) {
                            reqVO1.setOrgIds(relationOrgIds);
                        }
                    } else {
                        isUseAccountIds = false;
                    }
                    reqVO1.setSiteId(siteId);
                    List<ReportAccountRespVO> accounts = reportClient.getRangeAccounts(reqVO1);
                    //将用户id拿出并将用户信息放入map中
                    if (CollectionUtils.isNotEmpty(accounts)) {
                        for (ReportAccountRespVO accountRespVO : accounts) {
                            accountIds.add(accountRespVO.getUserId());
                            accountMap.put(accountRespVO.getUserId(), accountRespVO);
                        }
                    } else {
                        return null;
                    }
                }

            } else {
                return null;
            }

        }
        //如果所有次用户不为空则进行查找考试数据
        if (CollectionUtils.isNotEmpty(accountIds)) {
            List<ReadOnLineExamExportVO> list = null;
            //管理员全平台可见不需要加入用记筛选
            if (!isUseAccountIds) {
                list = examOnlineReadOverMapper.studentExamExport(examId, null);
            } else {
                list = examOnlineReadOverMapper.studentExamExport(examId, accountIds);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                for (ReadOnLineExamExportVO readOnLineExamExportVO : list) {
                    Long accountId1 = readOnLineExamExportVO.getAccountId();

                    //组装用户信息
                    ReportAccountRespVO account = accountMap.get(accountId1);
                    //如果是全平台没找到用户信息移除该条记录
                    if (null == account) {
                        list.remove(readOnLineExamExportVO);
                        continue;
                    }
                    readOnLineExamExportVO.setAccountName(account.getUserName());
                    readOnLineExamExportVO.setAccountFullName(account.getUserFullName());
                    readOnLineExamExportVO.setAccountState(account.getStatus());
                    readOnLineExamExportVO.setOrgName(account.getOrgName());
                    //如果有记录将id移除,便于之后插入没有数据的用户信息
                    if (accountIds.contains(accountId1)) {
                        accountIds.remove(accountId1);
                    }
                }
            }
            //如果有没有记录的用户组装加入结果中
            if (CollectionUtils.isNotEmpty(accountIds)) {
                for (Long id : accountIds) {
                    ReportAccountRespVO accountRespVO = accountMap.get(id);
                    ReadOnLineExamExportVO readVO = new ReadOnLineExamExportVO();
                    readVO.setAccountId(id);
                    readVO.setAccountName(accountRespVO.getUserName());
                    readVO.setAccountFullName(accountRespVO.getUserFullName());
                    readVO.setAccountState(accountRespVO.getStatus());
                    readVO.setOrgName(accountRespVO.getOrgName());
                    readVO.setJoinState(0);
                    list.add(readVO);
                }
            }

            return list;
        } else {
            return null;
        }

    }

    @Override
    public Map<Long, Integer> getQualifiedNum(List<Long> examIds) {

        Map<Long, Integer> map = new HashMap<>();
        Log.info("参数：" + examIds);
//        List<QualifiedNumVO> list = examOnlineReadOverMapper.getQualifiedNum(examIds);

        List<QualifiedNumVO> list = new ArrayList<>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT\n" +
                "        t.exam_id as examId,\n" +
                "        COUNT( DISTINCT t.account_id) as qualifiedNum\n" +
                "        FROM\n" +
                "        tr_exam_answer t\n" +
                "        LEFT JOIN exam e ON t.exam_id = e.id\n" +
                "        WHERE t.state = 2\n");
        if (CollectionUtils.isNotEmpty(examIds)) {
            StringBuilder s = new StringBuilder();
            for (Long c : examIds) {
                int i = examIds.size() - 1;
                if (examIds.indexOf(c) != i) {
                    s.append(c).append(",");
                } else {
                    s.append(c);
                }
            }
            System.out.println(s);
            sql.append(" AND t.exam_id IN(").append(s).append(")");
        }
        sql.append
                ("        AND t.score >= e.qualified_score\n" +
                        "        GROUP BY\n" +
                        "        exam_id");

        Connection conn = this.sqlSessionBatch().getConnection();

        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            Log.info("执行的sql={}", sql.toString());
            rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                QualifiedNumVO qualifiedNumVO = new QualifiedNumVO();
                qualifiedNumVO.setExamId(rs.getLong("examId"));
                qualifiedNumVO.setQualifiedNum(rs.getInt("qualifiedNum"));
                list.add(qualifiedNumVO);
            }
            rs.close();
        } catch (Exception e) {
            e.printStackTrace();
            return map;
        } finally {
            if (null != rs) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (null != st) {
                try {
                    st.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (null != conn) {
                try {
                    conn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        if (CollectionUtils.isNotEmpty(list)) {
            for (QualifiedNumVO qualifiedNumVO : list) {
                map.put(qualifiedNumVO.getExamId(), qualifiedNumVO.getQualifiedNum());
            }
            return map;
        } else {
            return null;
        }
    }
}
