/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamAnswerClient
 * Author:   phone
 * Date:     2018/3/21 14:54
 * Description: 答卷详情
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.AnswerDetailVO;
import com.yizhi.exam.application.vo.ExamAnswerByUserVO;
import com.yizhi.exam.application.vo.domain.TrExamAnswer;
import com.yizhi.exam.application.vo.exam.StatisticalCountVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈答卷详情〉
 *
 * @author phone
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamAnswerClient")
public interface ExamAnswerClient {

    @GetMapping("/manage/exam/count/account/answer")
    AnswerDetailVO getAnswer(@RequestParam("examId") Long examId, @RequestParam("examNum") Integer examNum, @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,@RequestParam(name = "accountId", required = false) Long accountId);

    @PostMapping("/manage/exam/export/result")
    boolean getExamAnswer(@RequestParam("response")HttpServletResponse response,@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/result/details")
    Map<String,Object> answerQuestionDetail(@RequestParam("answerId")Long answerId, @RequestParam("pageSize")Integer pageSize, @RequestParam("pageNo")Integer pageNo);

    /**
     * 根据考试ID查询交卷人数
     * */
    @GetMapping("/manage/exam/submit/count")
    int submitCount(@RequestParam("examId") Long examId);

    /**
     * 获取考试通过人数
     * */
    @GetMapping("/manage/exam/select/count")
    Integer selectByCount(@RequestParam("examId") Long examId);

    /**
     * 获取考试总人数和总分数用来计算平均分和完成率
     * */
    @GetMapping("/manage/exam/select/statical")
    StatisticalCountVO selectStaticalCount(@RequestParam("examId")Long examId);
    
    /**
     * 考试详情
     */
    @PostMapping("/manage/exam/statistical/exam/userDetail")
    List<AnswerDetailVO> getAnswerDetailList(@RequestBody ExamAnswerByUserVO vo);
    
    
    @GetMapping("/manage/exam/getEarlyPassExamIdByExamIds")
    List<TrExamAnswer> getEarlyPassExamIdByExamIds(@RequestParam(name="listIds",required=true)List<Long> listIds);

    /**
     * 找出一个学员在一场考试中的最高分(已阅卷)
     *
     * @param examId
     * @param accountId
     * @param companyId
     * @param siteId
     * @return
     */
    @GetMapping("/manage/exam/getMaxScore")
    Integer getMaxScore(@RequestParam("examId") Long examId,@RequestParam("accountId") Long accountId,@RequestParam("companyId") Long companyId,@RequestParam("siteId") Long siteId);
}