/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamAuthorizeClient
 * Author:   phone
 * Date:     2018/3/28 11:49
 * Description: 考试人员范围
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.domain.TrExamAuthorize;
import com.yizhi.exam.application.vo.exam.VisibleRangeExport;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈考试人员范围〉
 *
 * @author fanchunhui
 * @create 2018/3/28
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamAuthorizeClient")
public interface ExamAuthorizeClient {

    @PostMapping(value="/manage/exam/account/list")
    List<Long> findStudentByExamId(@RequestParam("examId") Long examId);

    @GetMapping("/manage/exam/authorize")
    List<TrExamAuthorize> examCount(@RequestParam(name = "examId") Long examId);

    @PostMapping("/manage/exam/authorize/insert")
    Boolean insertTrExamAuthorizes(@RequestBody List<TrExamAuthorize> trExamAuthorizes);
    
    
    /**
     *  王飞达
	  * 可见范围导出
	  * @param assignmentId
	  * @return
	  */
	 @GetMapping("/manage/exam/export/visiblRange")
	 public VisibleRangeExport exportVisibleRange(@RequestParam(name="examId",required=true)Long assignmentId);

}