package com.yizhi.exam.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.exam.application.vo.ExamCountByUserVO;
import com.yizhi.exam.application.vo.report.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 试报表统计Feign接口
 *
 * @author mei
 */
@FeignClient(name = "exam", contextId = "ExamReportClient")
public interface ExamReportClient {
    /**
     * 导出考试答卷(题目，答案选择项)
     *
     * @param paramMaps 参数MAP
     * @return
     */
    @GetMapping("/manage/exam/answer/student/export")
    public void downStudentExamAnswer(@RequestParam Map<String, Object> paramMaps);

    /**
     * 按考试统计-查看（按分数段）
     *
     * @param examId
     * @return
     */
    @GetMapping("/manage/report/exam/score/group/view")
    List<ReportExamChartsVo> getExamScoreGroupView(@RequestParam(name = "examId", required = true) Long examId,
                                                   @RequestParam(name = "startTime", required = false) String startTime,
                                                   @RequestParam(name = "endTime", required = false) String endTime);

    /**
     * 按考试统计
     *
     * @param paramMaps
     * @return
     */
    @GetMapping("/manage/report/exam/group")
    Page<ReportExamVO> getExamGroup(@RequestBody ReportExamParam reportExamParam);

    /**
     * 按考试统计（按用户统计）
     */
    @GetMapping("/manage/report/exam/group/account")
    Page<ReportExamAccountsViewVo> getExamAndAccountGroup(@RequestBody ExamCountByUserVO vo);

    /**
     * 按考试统计（按用户统计下载考试明细）
     */
    @GetMapping("/manage/report/exam/group/account/examView")
    Page<ReportExamAccountsViewVo> getExamAndAccountGroupView(
            @RequestParam(name = "examId", required = false) Long examId,
            @RequestParam(name = "siteId", required = false) Long siteId,
            @RequestParam(name = "accountId", required = false) Long accountId,
            @RequestParam(name = "isAdmin", required = false) boolean isAdmin,
            @RequestParam(name = "accountNameLike", required = false) String accountNameLike,
            @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @RequestParam(name = "startTime", required = false) String startTime,
            @RequestParam(name = "endTime", required = false) String endTime,
            @RequestParam(name = "pageNo", required = false) int pageNo,
            @RequestParam(name = "pageSize", required = false) int pageSize);

    /**
     *
     *
     */

    /**
     * 按用户统计
     *
     * @param paramMaps
     * @return
     */
    @GetMapping("/manage/report/exam/account/group")
    Page<ReportExamAccountVO> getExamAccountGroup(@RequestBody ExamCountByUserVO vo);

    /**
     * 按考试统计-查看（按考题统计）
     *
     * @param examId
     * @return
     */
    @GetMapping("/manage/report/exam/sub/group/view")
    List<ReportExamSubjectChartsVotr> getExamSubGroupView(@RequestParam(name = "examId", required = true) Long examId,
                                                          @RequestParam(name = "startTime", required = false) String startTime,
                                                          @RequestParam(name = "endTime", required = false) String endTime);

    /**
     * 按用户统计-查看
     */
    @GetMapping("/manage/report/exam/account/group/view")
    Page<ReportExamAccountViewVo> getExamAccountGroupView(@RequestParam(name = "accountId", required = true) Long accountId,
                                                          @RequestParam(name = "startTime", required = false) String startTime,
                                                          @RequestParam(name = "endTime", required = false) String endTime,
                                                          @RequestParam(name = "examNameLike", required = false) String examNameLike,
                                                          @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                                          @RequestParam(name = "pageSize", required = true) Integer pageSize);

}
