/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: MyExamClient
 * Author:   phone
 * Date:     2018/3/28 14:35
 * Description: 我的考试学员端
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.MyExamParameterVO;
import com.yizhi.exam.application.vo.MyExamVO;
import com.yizhi.exam.application.vo.exam.MyExamPageVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈我的考试学员端〉
 *
 * @author phone
 * @create 2018/3/28
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "MyExamClient")
public interface MyExamClient {

    @PostMapping("/api/exam/list")
    MyExamPageVO getMyExamList(@RequestBody MyExamParameterVO myExamParameterVO);
    @PostMapping("/api/exam/list1")
    MyExamPageVO getMyExamListNew(@RequestBody MyExamParameterVO myExamParameterVO);
    
    /**
     * 获取4天内创建的所有考试信息（不用分页）
     * @param myExamParameterVO
     * @return
     */
    @PostMapping("/api/exam/listFour")
    List<MyExamVO> getMyExamListFour(@RequestBody MyExamParameterVO myExamParameterVO);

    /**
     * pc端我的考试列表
     *
     * @param myExamParameterVO
     * @return
     */
    @PostMapping("/api/exam/pcList")
    MyExamPageVO getMyPcExamList(@RequestBody MyExamParameterVO myExamParameterVO);

    /**
     * 我的考试搜索
     * @param keyWord
     * @param pageNo
     * @param pageSize
     * @param accountId
     * @param siteId
     * @param ids
     * @return
     */
    @GetMapping("/api/exam/search")
    MyExamPageVO searchMyExamInfo(@RequestParam(value="keyWord", required = false)String keyWord, @RequestParam("pageNo")Integer pageNo, @RequestParam("pageSize")Integer pageSize, 
    		@RequestParam("accountId")Long accountId, @RequestParam("siteId")Long siteId, @RequestParam("ids")List<Long> ids);

    @GetMapping("/api/exam/finishedIds")
    List<Long> getMyFinishedIds(@RequestParam("accountId") Long accountId,
                                @RequestParam("siteId") Long siteId,
                                @RequestParam("examIds") List<Long> examIds);
}