package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.domain.TrQuestionLibrarySubject;
import com.yizhi.exam.application.vo.QuestionLibrarySubjectVO;
import com.yizhi.exam.application.vo.TrQuestionLibrarySubjectVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈管理端题库试题〉
 *
 * @author fan'chun'hui
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "QuestionLibrarySubjectClient")
public interface QuestionLibrarySubjectClient {

    @GetMapping("/manage/question/exam/list")
    Map<String, Object> getLibraryQuestion(@RequestParam("id") Long id, @RequestParam("examId") Long examId, @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize, @RequestParam(name = "key", required = false) String key, @RequestParam(name = "type", required = false) Integer type);

    @PostMapping("/manage/question/exam/insert")
    Long insert(@RequestBody TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO);

    @PostMapping("/manage/question/exam/insertList")
    boolean insertList(@RequestBody List<TrQuestionLibrarySubjectVO> trQuestionLibrarySubjectVOList);

    @GetMapping("/manage/question/exam/get/question")
    QuestionLibrarySubjectVO selectById(@RequestParam("id") Long id);

    @PostMapping("/manage/question/exam/update")
    int update(@RequestBody TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO);

    @GetMapping("/manage/question/exam/use")
    int isUse(@RequestParam("id") Long id);

    @GetMapping("/manage/question/exam/list/all")
    List<TrQuestionLibrarySubject> queryQuestionLibraryList(@RequestParam(name = "libraryId", required = false) Long libraryId,
                                                            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize);

}