package com.yizhi.exam.application.vo;

import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Api(tags = "AnswerQuestionDetailVO", description = "答卷页面")
public class AnswerQuestionDetailVO {

	@ApiModelProperty(notes = "考试ID")
	private Long examId;

	@ApiModelProperty(notes = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	private String stemAppendixUrl;

	@ApiModelProperty(notes = "题干，题目内容")
	private String stem;

	@ApiModelProperty(notes = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(notes = "题目序号")
	private Integer sort;

	@ApiModelProperty(notes = "题目解析，只支持文本")
	private String analysis;

	@ApiModelProperty(notes = "答卷ID")
	private Long answerId;

	@ApiModelProperty(notes = "考试题目ID")
	private Long answerQuestionId;

	@ApiModelProperty(value = "答题是否正确 0:错误, 1:正确")
	Integer isTrue;

	@ApiModelProperty(value = "正确答案")
	List<String> rightAnswers;

	@ApiModelProperty(value = "分数")
	String score;

	@ApiModelProperty(value = "题干分值")
	BigDecimal fullScore;

	@ApiModelProperty(notes = "问答题，学员答卷内容")
	private String answerValue;

	@ApiModelProperty(notes = "选项集合")
	List<AnswerQuestionListVO> options;

	@ApiModelProperty(notes = "题目标记符号：0未标记；1标记")
	private Integer mark;
}
