package com.yizhi.exam.application.vo;

import java.util.List;

import com.yizhi.exam.application.vo.domain.Exam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamVO", description = "考试")
@Data
public class ExamVO {

	@ApiModelProperty(value = "手动出题题型的分数及数量")
	private List<ExamQuestionTypeVO> typeVOS;

	@ApiModelProperty(value = "系统出题题型的分数及数量")
	List<TrExamSystemQuestionVO> trExamSystemQuestionVOS;

	@ApiModelProperty(value = "试题列表")
	private List<ExamQuestionLibraryVO> examQuestionLibraryVOS;

	@ApiModelProperty(value = "考试实体")
	private Exam exam;

	@ApiModelProperty(value = "考试分数通用评价实体")
	private List<TrExamScoreEvaluateVO> trExamScoreEvaluateVO;

	@ApiModelProperty(value = "考试积分实体")
	private List<TrExamPointVO> TrExamPointVO;
	
	@ApiModelProperty(value = "提醒设置列表")
	private TrExamRemindVO trExamRemindVO;

}
