package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "TrQuestionLibrarySubjectVO", description = "")
@Data
public class TrQuestionLibrarySubjectVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "标签，如：金融，保险等（允许为空）可设置标签，最多设置5个，只支持文本，最多输入10个汉字。")
	private String questionLabel;

	@ApiModelProperty(value = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	private String stemAppendixUrl;

	@ApiModelProperty(value = "评分说明，允许为空（文本），对题型是问答题有效")
	private String scoreRule;


	@ApiModelProperty(value = "题库_ID主键，外键")
	private Long libraryId;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "题目解析，只支持文本")
	private String analysis;

	@ApiModelProperty(value = "选项列表允许为空，有则填写")
	List<TrQuestionSubjectOptionVO> trQuestionSubjectOptionVOList;

	@ApiModelProperty(value = "企业ID")
	Long companyId;

	@ApiModelProperty(value = "站点ID")
	Long siteId;

	@ApiModelProperty(value = "用户姓名")
	String accountName;

	@ApiModelProperty(value = "部门ID")
	Long orgId;

	@ApiModelProperty(value = "用户ID")
	Long accountId;
}
