package com.yizhi.exam.application.vo.exam;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamProgressVO", description = "考试进展")
@Data
public class ExamProgressVO {
	
	@ApiModelProperty(value="答案题目ID")
	private Long ansQId;
	
	@ApiModelProperty(value="题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;
	
	@ApiModelProperty(value="选项")
	private List<StudentOptionVO> ops;
	
	@ApiModelProperty(value="主观题答案")
	private String sub;

	@ApiModelProperty("题目标记")
	private Integer mark;
	
	@ApiModelProperty(value = "是否作答标记（后端使用）", hidden = true)
	private Boolean isAnswer;
}
