/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: QuestionSortVO
 * Author:   phone
 * Date:     2018/4/19 16:11
 * Description: 试题排序VO
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo.exam;

import com.yizhi.exam.application.vo.domain.TrExamQuestionSort;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈试题排序VO〉
 *
 * @author phone
 * @create 2018/4/19
 * @since 1.0.0
 */
@Data
public class QuestionSortVO {

    @ApiModelProperty("考试ID")
    private Long examId;

    @ApiModelProperty("0手动出题,1系统出题")
    private Integer type;

    @ApiModelProperty("系统出题_出题策略，1.抽题组卷（每个学员使用同一份试卷） 2随机组卷（每个学员使用不同试卷）")
    private Integer sysMakeStrategy;

    @ApiModelProperty(value = "题干排序，1默认排序 2题型排序 3随机排序")
    private Integer stemSort;

    @ApiModelProperty(value = "题型排序，1默认排序 2随机排序")
    private Integer typeSort;

    @ApiModelProperty(value = "选项排序，1默认排序 2随机排序")
    private Integer optionSort;

    @ApiModelProperty(value = "试题题型排序列表")
    private List<TrExamQuestionSort> trExamQuestionSorts;

    @ApiModelProperty("用户ID")
    private Long accountId;

    @ApiModelProperty("用户姓名")
    private String accountName;

}