package com.yizhi.application.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.application.service.*;
import com.yizhi.application.domain.Exam;
import com.yizhi.application.domain.QuestionLibrary;
import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.TypeAndCountVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yizhi.exam.application.vo.ListLibraryVO;
import com.yizhi.exam.application.vo.QuestionLibraryVO;


/**
 * <p>
 * 题库 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
//@CrossOrigin
@RequestMapping("/manage/question")
public class QuestionLibraryController {

    private static Logger Log = LoggerFactory.getLogger(QuestionLibraryController.class);

    @Autowired
    IQuestionLibraryService iQuestionLibraryService;

    @Autowired
    IdGenerator idGenerator;

    @Autowired
    ITrQuestionLibrarySubjectService iTrQuestionLibrarySubjectService;

    @Autowired
    private IExamService iExamService;

    @Autowired
    private ITrExamQuestionService iTrExamQuestionService;

    @Autowired
    private ITrExamSystemQuestionService iTrExamSystemQuestionService;

    /**
     * 删除题库
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/delete")
    public Boolean delete(@RequestParam Long id) {
        Boolean b = false;
        try {
            b = iQuestionLibraryService.libDelete(id);
            return b;
        } catch (Exception e) {
            Log.error("", e);
            return b;
        }
    }

    /**
     * 批量删除题库
     *
     * @param
     * @return
     */
    @GetMapping(value = "/deletes")
    public boolean batchDelete(@RequestParam Long[] ids) {
        Boolean b = false;
        try {
            b = iQuestionLibraryService.libDeleteBatch(ids);
            return b;
        } catch (Exception e) {
            Log.error("", e);
            return b;
        }
    }


    /**
     * 导入题库试题
     *
     * @param
     * @return
     */
    @PostMapping(value = "/exam/import")
    public boolean insertByFile(@RequestParam String fileDir, @RequestParam String fileName, Long id) {
        Boolean b = false;
        try {
            b = iQuestionLibraryService.importQuestionLibrary(fileDir, fileName, id);
            return b;
        } catch (Exception e) {
            Log.error("", e);
            return b;
        }
    }

    /**
     * 批量删除题库试题
     *
     * @param
     * @return
     */
    @PostMapping(value = "/exam/deletes")
    public boolean batchExamDelete(@RequestBody List<Long> ids) {
        boolean b = false;
        try {
            b = iTrQuestionLibrarySubjectService.questionDeleteBatch(ids);
            return b;

        } catch (Exception e) {
            Log.error("", e);
            return b;
        }
    }

	@GetMapping("/list")
	public Map<String,Object> list(
			@RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
		List<ListLibraryVO> list = null;
		Map<String,Object> map = new HashMap<String,Object>();
		try {
			RequestContext requestContext=ContextHolder.get();
			List<Long> managerIds = null;
			if(!requestContext.isAdmin() && !CollectionUtils.isEmpty(requestContext.getManagerIds())){
				managerIds = requestContext.getManagerIds();
			}
				list=iQuestionLibraryService.getList(contextAndPageSizeVO,managerIds);

            int count = iQuestionLibraryService.selectLibraryCount(contextAndPageSizeVO, managerIds);
            Map<String, Integer> page = new HashMap<String, Integer>();
            page.put("pageNo", contextAndPageSizeVO.getPageNo());
            page.put("pageSize", contextAndPageSizeVO.getPageSize());
            page.put("pageTotal", count);
            map.put("list", list);
            map.put("page", page);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }

    @PostMapping("/insert")
    public boolean insert(@RequestBody QuestionLibraryVO questionLibraryVO) {
        boolean result = false;
        try {
            result = iQuestionLibraryService
                    .insertQuestionLibraryAndTrQuestionLibrarySubjectService(questionLibraryVO);
            return result;
        } catch (Exception e) {
            Log.error("新建题库失败！", e);
            return result;
        }
    }

    @PostMapping("/update")
    public boolean update(@RequestBody QuestionLibraryVO questionLibraryVO) {
        boolean result = false;
        try {
            result = iQuestionLibraryService
                    .updateQuestionLibraryAmdTrQuestionLibrarySubjectService(questionLibraryVO);
            return result;
        } catch (Exception e) {
            Log.error("修改题库失败！", e);
            return result;
        }
    }

    @GetMapping("/get/id")
    public Long getQuestionLibraryId() {
        return idGenerator.generate();
    }

    @GetMapping("/get/questionLibrary")
    public QuestionLibraryVO selectQuestionLibraryById(@RequestParam(name = "id") Long id) {
        QuestionLibraryVO questionLibraryVO = iQuestionLibraryService.selectQuestionLibraryById(id);
        return questionLibraryVO;
    }

    /**
     * 查看题库名称是否存在
     */
    @GetMapping("/name/exist")
    public QuestionLibrary nameIsExist(@RequestParam("name") String name) {
        return iQuestionLibraryService.nameIsExist(name);
    }

    @GetMapping("/library/type/count")
    public List<TypeAndCountVo> getTypeAndCount(
            @RequestParam(name = "examId", required = false) Long examId,
            @RequestParam(name = "libraryId", required = false) Long libraryId) {
        List<TypeAndCountVo> list;
        if (examId == null || libraryId == null) {
            return new ArrayList<>();
        }
        Exam exam1 = iExamService.selectById(examId);
        if (exam1.getLibraryId() != null && !libraryId.equals(exam1.getLibraryId())) {
            iTrExamQuestionService.updateByExamId(examId);
            Map<String, Object> clownMap = new HashMap<>();
            clownMap.put("exam_id", examId);
            iTrExamSystemQuestionService.deleteByMap(clownMap);
        }
        //保存题库的id和名称
        QuestionLibrary questionLibrary = iQuestionLibraryService.selectById(libraryId);
        if (null==questionLibrary){
            return null;
        }
        Exam exam = new Exam();
        exam.setId(examId);
        exam.setLibraryId(libraryId);
        exam.setLibraryName(questionLibrary.getName());
        iExamService.updateById(exam);
        list = iQuestionLibraryService.getTypeAndCount(examId, libraryId);
        return list;
    }
}
