package com.yizhi.application.controller;

import com.yizhi.application.domain.TrExamAuthorize;
import org.springframework.web.bind.annotation.*;

import com.yizhi.application.service.ITrExamAuthorizeService;


import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * <p>
 * 考试人员范围 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/manage/exam")
public class TrExamAuthorizeController {
	@Autowired
	private ITrExamAuthorizeService iTrExamAuthorizeService;
	
	@PostMapping(value="/account/list")
	public List<Long> findStudentByExamId(@RequestParam(name = "examId") Long examId){
		List<Long> studentIdList = null;
		try{
			studentIdList= iTrExamAuthorizeService.examIdList(examId);
			return studentIdList;
		}catch (Exception e) {
			e.printStackTrace();
			return studentIdList;
		}
	}

	@GetMapping("/authorize")
	public List<TrExamAuthorize> examCount(@RequestParam("examId") Long examId){
		List<TrExamAuthorize> trExamAuthorizes = null;
		try {
			trExamAuthorizes = iTrExamAuthorizeService.examCount(examId);
			return trExamAuthorizes;
		}catch (Exception e){
			e.printStackTrace();
			return trExamAuthorizes;
		}
	}

	@PostMapping("/authorize/insert")
	public Boolean insertTrExamAuthorizes(@RequestBody List<TrExamAuthorize> trExamAuthorizes){
		Boolean f = iTrExamAuthorizeService.insertAll(trExamAuthorizes);
		return f;
	}

}
