package com.yizhi.application.controller;

import java.util.*;

import com.yizhi.application.domain.TrQuestionSubjectOption;
import com.yizhi.exam.application.vo.QuestionLibrarySubjectVO;
import com.yizhi.exam.application.vo.TrQuestionLibrarySubjectVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.service.ITrQuestionSubjectOptionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yizhi.application.domain.TrQuestionLibrarySubject;
import com.yizhi.exam.application.vo.ExamQuestionLibraryVO;
import com.yizhi.application.service.IQuestionLibraryService;
import com.yizhi.application.service.ITrQuestionLibrarySubjectService;

/**
 * <p>
 * 题目 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/manage/question/exam")
public class TrQuestionLibrarySubjectController {
    private static final Logger LOG = LoggerFactory.getLogger(TrQuestionLibrarySubjectController.class);
    @Autowired
    ITrQuestionLibrarySubjectService iTrQuestionLibrarySubjectService;
    @Autowired
    IQuestionLibraryService iQuestionLibraryService;
    @Autowired
    ITrQuestionSubjectOptionService iTrQuestionSubjectOptionService;

    /**
     * 根据题库id查找所有的试题
     *
     * @return
     */
    @GetMapping("/list")
    public Map<String, Object> getLibraryQuestion(
            @RequestParam(name = "id", required = false) Long id,
            @RequestParam(value = "examId", required = false) Long examId,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "key", required = false) String key,
            @RequestParam(name = "type", required = false) Integer type
    ) {
        Map<String, Object> map = null;
        try {
            // 获取所有的根据题库id查找到的所有题目id
            List<TrQuestionLibrarySubject> trQuestionLibrarySubjects = iTrQuestionLibrarySubjectService
                    .selectQuestionByLibraryId(id, pageNo, pageSize, key, type);
            Long subjectId;
            // 题目实体对象
            TrQuestionLibrarySubject trQuestionLibrarySubject;
            // VO类的集合，返回的对象
            List<ExamQuestionLibraryVO> examQuestionLibraryVOS = new LinkedList<ExamQuestionLibraryVO>();
            // VO类实体用来合并TrExamQuestion 和 TrQuestionLibrarySubject的属性
            ExamQuestionLibraryVO examQuestionLibraryVO;
            for (int i = 0; i < trQuestionLibrarySubjects.size(); i++) {
                trQuestionLibrarySubject = trQuestionLibrarySubjects.get(i);
                examQuestionLibraryVO = new ExamQuestionLibraryVO();
                subjectId = trQuestionLibrarySubject.getId();
                examQuestionLibraryVO.setId(subjectId);
                examQuestionLibraryVO.setStem(trQuestionLibrarySubject.getStem());
                examQuestionLibraryVO.setLibraryId(id);
                examQuestionLibraryVO.setType(trQuestionLibrarySubject.getType());
                // 这里需要调用判断题目状态的接口
                examQuestionLibraryVO.setStatus(iQuestionLibraryService.libraryState(id, subjectId));
                examQuestionLibraryVOS.add(examQuestionLibraryVO);
            }
            Map<String, Integer> page = new HashMap<String, Integer>();
            page.put("pageSize", pageSize);
            page.put("pageNo", pageNo);
            page.put("pageTotal", iTrQuestionLibrarySubjectService.selectLibrarySubjectsCount(id, key, type));
            map = new HashMap<String, Object>();
            map.put("list", examQuestionLibraryVOS);
            map.put("page", page);
            return map;
        } catch (Exception e) {
            LOG.error("", e);
            e.printStackTrace();
            return map;
        }
    }

    @PostMapping("/insert")
    public Long insert(@RequestBody TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) {
        Long result = null;
        try {
            result = iTrQuestionLibrarySubjectService.insert(trQuestionLibrarySubjectVO);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    @PostMapping("/insertList")
    public boolean insertList(@RequestBody List<TrQuestionLibrarySubjectVO> trQuestionLibrarySubjectVOList) {
        boolean result;
        try {
            result = iTrQuestionLibrarySubjectService.insertList(trQuestionLibrarySubjectVOList);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return result;
    }

    @GetMapping("/get/question")
    public QuestionLibrarySubjectVO selectById(@RequestParam("id") Long id) {
        return iTrQuestionLibrarySubjectService.selectQuestionLibrarySubject(id);
    }

    @PostMapping("/update")
    public int update(@RequestBody TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) {
        return iTrQuestionLibrarySubjectService.update(trQuestionLibrarySubjectVO);
    }

    @GetMapping("/use")
    public int isUse(@RequestParam("id") Long id) {
        return iTrQuestionLibrarySubjectService.selectIsUser(id);
    }

    @GetMapping("list/all")
    public List<TrQuestionLibrarySubject> queryQuestionLibraryList(@RequestParam(name = "libraryId", required = false) Long libraryId,
                                                                   @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        List<TrQuestionLibrarySubject> list = new ArrayList<>();
        if (libraryId != null && libraryId > 0) {
            list = iTrQuestionLibrarySubjectService.selectQuestionByLibraryId(libraryId, pageNo, pageSize, null, 0);
        }
        if (list.size() > 0 && null != list) {
            return list;
        }
        return null;

    }

    @GetMapping("/option/list")
    public List<TrQuestionSubjectOption> QueryTrQuestionSubjectOptionList(@RequestParam(name = "subjectId", required = false) Long subjectId) {
        return iTrQuestionSubjectOptionService.queryTrQuestionSubjectOptionList(subjectId);
    }
}