package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 考生试卷自动组卷信息
 * </p>
 *
 * @author mei
 * @since 2018-05-30
 */

@Data
@TableName("exam_student_auto_answer_info")
public class ExamStudentAutoAnswerInfo extends Model<ExamStudentAutoAnswerInfo> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("exam_id")
	private Long examId;
	
	
	@TableField("account_id")
	private Long accountId;

	
	private String content;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	@TableField("company_id")
	private Long companyId;

	
	@TableField("org_id")
	private Long orgId;

	
	@TableField("site_id")
	private Long siteId;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
