package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.exam.application.vo.AnswerQuestionDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionListVO;
import com.yizhi.exam.application.vo.AnswerVO;
import com.yizhi.exam.application.vo.ExamAnswerVO;
import com.yizhi.exam.application.vo.exam.AnswerTimeVO;
import com.yizhi.exam.application.vo.exam.ExamHistoryVO;
import com.yizhi.exam.application.vo.exam.StatisticalCountVO;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 答卷 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamAnswerMapper extends BaseMapper<TrExamAnswer> {
    /**
     * 根据考试id获得考试详情
     *
     * @return
     */
	/*List<ExamAnswerVO> selectExamAnswerListByExamId(@Param("examId") Long examId, @Param("start") Integer start,
			@Param("end") Integer end);
*/

    /**
     * 没有考试的人员id
     *
     * @return
     */
    List<Long> noExamListId(@Param("examId") Long examId, @Param("shouldListId") List shouldListId);

    /**
     * 根据考试id获得考试详情
     *
     * @return
     */
    List<ExamAnswerVO> selectExamAnswerByExamId(
            @Param("accountIdList") List<Long> accountIdList, @Param("orgIdList") List<Long> orgIdList,
            @Param("state") Integer state, @Param("tstart") Date tstart, @Param("tend") Date tend,
            @Param("examId") Long examId, @Param("start") Integer start, @Param("end") Integer end);

    /**
     * 考试答卷列表
     *
     * @param examId
     * @return
     */
    List<ExamAnswerVO> selectAnswer(@Param("examId") Long examId);

    Integer selectTotal(@Param("accountIdList") List<Long> accountIdList, @Param("orgIdList") List<Long> orgIdList,
                        @Param("state") Integer state, @Param("tstart") Date tstart, @Param("tend") Date tend,
                        @Param("examId") Long examId);


    Integer selectMaxScore(@Param("accountId") Long accountId);

    List<AnswerQuestionDetailVO> answerQuestionDetail(Page<AnswerQuestionDetailVO> page, @Param("answerId") Long answerId);

    List<AnswerQuestionListVO> answerQuestionDetails(@Param("answer_question_id") Long answeQuestionId);

    List<Long> getAnswerIdByAccountId(@Param("accountId") Long accountId, @Param("examId") Long examId);

    AnswerVO answerDetail(@Param("answerId") Long answerId);

    @Select("select e.duration,e.end_time as endTime,answer.start_time AS startTime from tr_exam_answer answer left join exam e on e.id = answer.exam_id where e.id = #{examId} and answer.id = #{answerId}")
    AnswerTimeVO selectTime(@Param("examId") Long examId, @Param("answerId") Long answerId);

    @Select("select a.id,submit_time as submitTime,b.qualified_score as qualifiedScore,a.score as score from tr_exam_answer a\n" +
            "left join exam b on b.id = a.exam_id\n" +
            "where a.exam_id = #{examId} and a.account_id = #{accountId}")
    List<ExamHistoryVO> selectExamHistory(Long examId, Long accountId);

    @Select("select count(*) from (SELECT id FROM tr_exam_answer where company_id = #{companyId} GROUP BY account_id)a")
    Integer selectCountGroupByAccountId(@Param("companyId") Long companyId);

    @Select("SELECT count(DISTINCT b.account_id) \n" +
            "FROM exam a\n" +
            "LEFT JOIN tr_exam_answer b ON a.id = b.exam_id \n" +
            "WHERE a.id=#{examId} AND a.id = b.exam_id  AND b.score >= a.qualified_score\n" +
            "GROUP BY b.exam_id")
    Integer selectByCount(@Param("examId") Long examId);

    @Select("SELECT count(a.account_id) AS num, IFNULL(SUM(score),0) AS score\n" +
            "FROM (\n" +
            "    SELECT count(DISTINCT b.account_id) AS account_id, max(IFNULL(b.score,0)) AS score\n" +
            "    FROM exam a\n" +
            "    LEFT JOIN tr_exam_answer b ON a.id = b.exam_id \n" +
            "    WHERE a.id=#{examId} AND a.id = b.exam_id  AND b.score >= a.qualified_score\n" +
            "    GROUP BY b.exam_id,b.account_id\n" +
            ") a")
    StatisticalCountVO selectStaticalCount(@Param("examId") Long examId);

    @Select("SELECT COUNT(DISTINCT account_id) FROM tr_exam_answer WHERE exam_id = #{examId} AND state in(1,2)")
    Integer selectSubmitCount(@Param("examId") Long examId);

    @Select("select a.id FROM tr_exam_answer a WHERE a.state in(1,2) and a.exam_id=#{examId} and a.account_id=#{accountId}")
    List<Long> getAnswerDetailListInfo(@Param("accountId") Long accountId, @Param("examId") Long examId);

    /**
     * 查询考生某场考试的最高分数
     *
     * @param accountId
     * @param examId
     * @return
     */
    TrExamAnswer selectMaxScoreByAccountIdAndExamId(@Param("accountId") Long accountId, @Param("examId") Long examId);

    AnswerQuestionListVO answerMainQuestionDetailByAnswerQuestionId(@Param("answerQuestionId") Long answerQuestionId);

    /**
     * 查找未提交的试卷
     *
     * @param companyId
     * @return
     */
    List<TrExamAnswer> getUnSubmitExam(@Param("companyId") Long companyId);

    /**
     * 查询所有的答卷
     *
     * @param accountId
     * @param examId
     * @return
     */
    @Select("select a.id FROM tr_exam_answer a WHERE a.exam_id=#{examId} and a.account_id=#{accountId}")
    List<Long> getAllAnswerDetailListInfo(@Param("accountId") Long accountId, @Param("examId") Long examId);

    @Select("select count(*) FROM tr_exam_answer a WHERE a.exam_id=#{examId} and a.account_id=#{accountId}")
    Integer selectMyExamCount(@Param("examId") Long examId, @Param("accountId") Long accountId);

    /**
     * 获取答卷标识
     *
     * @param answerId
     * @return
     */
    @MapKey("id")
    Map<Long, Map<String, String>> selectAnswerMark(@Param("answerId") Long answerId);

    Integer getFullScore(@Param("examId") Long examId, @Param("answerQuesionId") Long answerQuesionId);


    List<TrExamAnswer> getEarlyPassExamIdByExamIds(@Param("listIds") List<Long> listIds);

    BigDecimal getScoreByExamIdAndStartTime(@Param("examId") Long examId, @Param("startTime") String startTime);

    List<Long> getFinishedAccountIds(@Param("examId") Long examId, @Param("companyId") Long companyId, @Param("siteId") Long siteId);

    List<Long> getMyFinishedIds(@Param("accountId") Long accountId, @Param("siteId") Long siteId, @Param("examIds") List<Long> examIds);

    /**
     * 查找必答题分值
     *
     * @param answerId
     * @param examId
     * @return
     */
    @MapKey("id")
    Map<Long, Map<String, BigDecimal>> getQuestionFullScoreMap(@Param("answerId") Long answerId, @Param("examId") Long examId);

    /**
     * 查找系统出题分值
     *
     * @param examId
     * @return
     */
    @MapKey("type")
    Map<Integer, Map<String, BigDecimal>> getSystemQuestionFullScoreMap(@Param("examId") Long examId);


    /**
     * 获取list 根据参数
     * @param accountId
     * @param siteId
     * @return
     */
    List<TrExamAnswer> getListByAccountId(@Param("accountId")Long accountId,@Param("siteId")Long siteId);

    List<TrExamAnswer> getListByIds(@Param("ids") List<Long> ids,@Param("accountId") Long accountId,@Param("siteId")Long siteId);

    /**
     * 根据时间参数，获取当前用户的《考试id,考试次数》的map
     * @param
     * @return
     */
    @MapKey("exam_id")
    Map<Long, Integer> getJoinExamNum(@Param("accountId")Long accountId,@Param("siteId")Long siteId,@Param("ids") List<Long> ids);
    
    public List<TrExamAnswer> getBySiteAndDateScope(@Param("siteId")Long siteId, @Param("from")Date from, @Param("to")Date to);
}
