package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamAnswerQuestionRes;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 客观题答案选项（单选题，多选题，判断题） Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamAnswerQuestionResMapper extends BaseMapper<TrExamAnswerQuestionRes> {

    @Select("SELECT answer FROM tr_exam_answer_question_res WHERE answer_question_id = #{id} and answer_id = #{answerId} and option_id = #{optionId} AND answer = 1")
    Integer selectAnswer(@Param("id") Long id, @Param("answerId") Long answerId,@Param("optionId")Long optionId);
    
    /**
	 * 查询客观题选项
	 * @param answerId
	 * @param questionId
	 * @return
	 */
    @Select("SELECT * FROM tr_exam_answer_question_res "
    		+ "WHERE answer_question_id = #{questionId} and answer_id = #{answerId}")
    List<TrExamAnswerQuestionRes> selectAnswerQuestionOptionByAnswerIdAndQuestionId(@Param("answerId") Long answerId, 
    		@Param("questionId")Long questionId);

}
