package com.yizhi.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamAnswerQuestion;
import com.yizhi.exam.application.vo.exam.CardVO;
import com.yizhi.exam.application.vo.exam.ExamAnswerVO;
import com.yizhi.exam.application.vo.exam.ExamResultVO;
import com.yizhi.exam.application.vo.exam.QuestionListVO;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 绛旀棰樼洰 鏈嶅姟绫�
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamAnswerQuestionService extends IService<TrExamAnswerQuestion> {

	boolean saveExamAnswer(ExamAnswerVO vo);

	/**
	 * 正常提交考试
	 * @param vo
	 * @return
	 */
	ExamResultVO submitExamPage(ExamAnswerVO vo);

	/**
	 * 学员端题目标记
	 * */
	boolean mark(ExamAnswerVO examAnswerVO);

	/**
	 * 根据answerId查询标记
	 * */
	Map<Long, Map<String, String>> selectMark(Long answerId);

	/**
	 * 根据答卷ID和用户ID获取所有答案题目
	 * */
	List<QuestionListVO> selectAnswerQuestion(Long answerId, Long accountId);

	/**
	 * 考试失效时提交考试
	 * @param vo
	 * @return
	 */
	ExamResultVO submitExamLose(ExamAnswerVO vo);

	/**
	 * pc/微信端学员答卷答题卡
	 * @param answerId
	 * @return
	 */
    List<CardVO> getMyExamAnswerCards(Long answerId);
}
