package com.yizhi.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamOnlineReadOver;
import com.yizhi.exam.application.vo.ExamOnlineReadOverVo;
import com.yizhi.exam.application.vo.MarkStudentVO;
import com.yizhi.exam.application.vo.PaperInspectionVo;
import com.yizhi.exam.application.vo.exam.ReadOnLineExamExportVO;
import com.yizhi.exam.application.vo.UserInfoVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试阅卷 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamOnlineReadOverService extends IService<TrExamOnlineReadOver> {
    List<TrExamOnlineReadOver> getResults(Long examId);

	/**
	 * 没有阅卷的人数
	 * @param examid
	 * @return
	 */
	Integer getNoReadNum(Long examid);

	/**
	 * 保存阅卷信息
	 * @param trExamOnlineReadOver
	 * @return
	 */
	Boolean insertDetail(PaperInspectionVo paperInspectionVo);

	/**
	 * 展示试卷信息
	 * @param paperInspectionVo
	 * @return
	 */
	PaperInspectionVo messageDetail(Long id,String accountName);

	/**
	 * 阅卷列表
	 * @param examId
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	List<TrExamOnlineReadOver> list(Long examId,List<Long> accountIdList,Integer pageSize,Integer pageNo);


	/**
	 * 阅卷列表的记录数
	 * @param examId
	 * @param username
	 * @param name
	 * @param depart
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	Integer sumNum(Long examId,List<Long> accountIdList,Integer pageSize,Integer pageNo);

	/**
	 * 已经阅卷的人数
	 * @param examid
	 * @return
	 */
	Integer getReadNum(Long examid);

	List<ExamOnlineReadOverVo> selectList(Long examId, Integer pageNo, Integer pageSize, Map<Long,UserInfoVO> userInfoVOMap);

	/**
	 * 查询数量
	 * */
	Integer selectListCount(Long examId,Map<Long,UserInfoVO> userInfoVOMap);

	MarkStudentVO markStudent(Long id);

	Map<String, Object> insertMarkStudent(MarkStudentVO markStudentVO);

	/**
	 * 根据考试ID查询已阅卷人数
	 * */
	int readCount(Long examId);


	List<ReadOnLineExamExportVO> studentExamExport(Long accountId, boolean isAdmin, Long siteId, Long examId);

	Map<Long, Integer> getQualifiedNum(List<Long> examIds);
}
