package com.yizhi.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamQuestionSort;
import com.yizhi.exam.application.vo.TrExamQuestionSortVO;

import java.util.List;

/**
 * <p>
 * 试题类型排序（类型为：题型排序，有效） 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamQuestionSortService extends IService<TrExamQuestionSort> {

	/**
	 * 更新
	 * @param trExamQuestionSortVoList
	 * @param examId
	 * @return
	 */
	boolean updateTrExamQuestionSortList(List<TrExamQuestionSortVO> trExamQuestionSortVoList, Long examId);

	/**
	 * 复制
	 * @param oldExamId
	 * @param id
	 * @return
	 */
	boolean copyTrExamQuestionSort(Long oldExamId, Long id);

	/**
	 * 
	 * @param id
	 * @return
	 */
	List<TrExamQuestionSortVO> listTrExamQuestionSort(Long id);
	
	/**
	 * 新增所有试题类型排序
	 * */
	boolean insertAll(List<TrExamQuestionSort> trExamQuestionSorts);
}