package com.yizhi.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.yizhi.application.cache.annotation.ExamCach;
import com.yizhi.application.cache.annotation.ExamCachDel;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.domain.ExamStudentAutoAnswerInfo;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.domain.TrExamAnswerQuestion;
import com.yizhi.application.mapper.*;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.IStudentExamPaperService;
import com.yizhi.application.util.RandomUtil;
import com.yizhi.exam.application.vo.exam.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 考试试卷管理
 *
 * @author mei
 */
@Service
public class StudentExamPaperServiceImpl implements IStudentExamPaperService {

    private static Logger logger = LoggerFactory.getLogger(StudentExamPaperServiceImpl.class);

    @Autowired
    ExamPaperMapper examPaperMapper;

    @Autowired
    TrExamAnswerMapper trExamAnswerMapper;

    @Autowired
    TrExamAnswerQuestionMapper trExamAnswerQuestionMapper;

    @Autowired
    TrExamAnswerQuestionResMapper trExamAnswerQuestionResMapper;

    @SuppressWarnings("rawtypes")
    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    ExamStudentAutoAnswerInfoMapper examStudentAutoAnswerInfoMapper;

    /**
     * 创建考试题目，放入缓存中
     * 生成试卷全部按默认排序生成。如果有随机出题策略则在学员开始考试时，在已生成的试卷中随机挑选
     *
     * @param examId    考试ID
     * @param companyId 企业ID
     * @param orgId     组织ID
     * @param siteId    站点 ID
     * @param time      考试失效时间（秒）
     * @return 返回考试试题
     */
    @ExamCach(cacheName = "'exam'+'_'+#examId", cacheKey = "'exam'+'_'+#examId", expireTime = "#time")
    public ExamPaperVO makeExamQuestion(Long examId, Long companyId, Long orgId, Long siteId, Long time) {

        if (examId == null) {
            return null;
        }
        //获取考试信息
        ExamPaperVO examPaperVO;
        examPaperVO = examPaperMapper.selectExam(examId, companyId, null, null);
        if (examPaperVO == null) {
            return null;
        }

        /**
         * 生成试题，开始
         */
        //考试题目
        List<QuestionListVO> questions;

        //题干排序(1默认排序  3随机排序)
        Integer stemSort = examPaperVO.getStemSort();

        //题型排序(1随机排序 2指定排序)
        Integer typeort = examPaperVO.getTypeSort();

        //获取必答试题,按默认规则排序
        questions = examPaperMapper.selectQuestionList(examId, stemSort);

        // 题型排序，为指定排序（2）时获取
        if (typeort != null && typeort == ExamConstant.TYPE_SORT_TYPE) {
            List<ExamQuestionSortVO> examQuestionSorts = examPaperMapper.selectExamQuestionSorts(examId);
            //没有题型排序，就默认添加
            if (null == examQuestionSorts || examQuestionSorts.size() == 0) {
                if (null == examQuestionSorts) {
                    examQuestionSorts = new ArrayList<ExamQuestionSortVO>();
                }
                ExamQuestionSortVO item = null;
                //添加单选题
                item = new ExamQuestionSortVO();
                item.setSort(0);
                item.setType(1);
                examQuestionSorts.add(item);
                //添加多选题
                item = new ExamQuestionSortVO();
                item.setSort(1);
                item.setType(2);
                examQuestionSorts.add(item);
                //添加判断题
                item = new ExamQuestionSortVO();
                item.setSort(2);
                item.setType(3);
                examQuestionSorts.add(item);
                //添加问答题
                item = new ExamQuestionSortVO();
                item.setSort(3);
                item.setType(4);
                examQuestionSorts.add(item);
            }
            examPaperVO.setExamQuestionSorts(examQuestionSorts);
        }

        // 出题策略，为系统出题(2)时获取
        Integer makeStrategy = examPaperVO.getMakeStrategy();
        if (makeStrategy == ExamConstant.MAKE_OUT_SYSTEM) {
            //获取系统出题规则
            List<QuestionOptionSystemListVO> sysQuestionOptions = examPaperMapper.selectQuestionOptionSystemList(examId);
            examPaperVO.setQuestionSystemOptions(sysQuestionOptions);

            //从题库中抽题
            Map<String, List<QuestionListVO>> libMapQuestions = new HashMap<String, List<QuestionListVO>>();
            for (QuestionOptionSystemListVO item : sysQuestionOptions) {
                Long libraryId = item.getLibraryId();
                Integer libQueType = item.getType();//题库的题型
                List<QuestionListVO> libQs = examPaperMapper.selectLibraryQuestionList(examId, libraryId, libQueType, makeStrategy);
                libMapQuestions.put(libraryId.toString() + "_" + libQueType.toString(), libQs);
            }
            examPaperVO.setLibQuestions(libMapQuestions);
            logger.info("********************************************************抽题题库题数" + libMapQuestions.size());

            //题库抽题,默认是抽题组卷,则把试卷组成好,所有人用同一份试卷
            Integer sysMakeStrategy = examPaperVO.getSysMakeStrategy();
            if (sysQuestionOptions != null && sysMakeStrategy.equals(ExamConstant.MAKE_OUT_SYSTEM_SAMPLE)) {
                questions = groupSubject(examPaperVO, questions, true);
                logger.info("****************************************************抽题数" + questions.size());
            }
        }
        //生成试题，结束

        if (null == questions) {
            questions = new ArrayList<QuestionListVO>();
        }
        examPaperVO.setQuestions(questions);

        logger.info("创建考试:" + examId + " 放入缓存中，失效时间:" + time.toString() + "秒后");

        return examPaperVO;
    }

    /**
     * 创建考生试卷，放入缓存中
     *
     * @param accountId 考生ID
     * @param examId    考试ID
     * @param time      考试失效时间（秒）
     * @return 返回考生试卷
     */
    @Transactional(propagation = Propagation.REQUIRED)
    @ExamCach(cacheName = "'accountId'+'_'+#accountId+'_'+#examId", cacheKey = "'accountId'+'_'+#accountId+'_'+#examId", expireTime = "#time")
    public StudentExamPaperVO makeStudentExam(ExamPaperVO examPaperVO, Long accountId, Long examId, Long time, Date createTime) {

//        logger.info("为考生:" + examPaperVO.getAccountId() + " 创建试卷，放入缓存中");
//        if (examPaperVO == null || examPaperVO.getExamId() == null) {
//            logger.info("没找到该考生:" + examPaperVO.getAccountId() + " 试卷");
//            return null;
//        }
//
//        //取出试题
        List<QuestionListVO> questions = examPaperVO.getQuestions();
        logger.info("^^^^^^^#########################$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$####################根据策略，准备组装出题数据的条数={}", questions.size());
//        if (questions == null || questions.size() == 0) {
//            logger.info("没找到该考生:" + examPaperVO.getAccountId() + " 试题");
//            return null;
//        }

        //出题策略是系统出题，并随机组卷,每个学员将使用不同试卷
        Integer makeStrategy = examPaperVO.getMakeStrategy();
        Integer sysMakeStrategy = examPaperVO.getSysMakeStrategy();
        if (makeStrategy == ExamConstant.MAKE_OUT_SYSTEM && sysMakeStrategy == ExamConstant.MAKE_OUT_SYSTEM_RANDOM) {
            questions = groupSubject(examPaperVO, questions, true);
            logger.info("^^^^^^^#########################$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$####################根据策略1，组装完成出题数据的条数={}", questions.size());
        }
        //题型排序（随机）
        Integer typeSort = examPaperVO.getTypeSort();

        //题干排序（随机）
        Integer stemSort = examPaperVO.getStemSort();
        //选项随机排序
        Integer optionSort = examPaperVO.getOptionSort();
        if ((makeStrategy == ExamConstant.MAKE_OUT_HAND || (makeStrategy == ExamConstant.MAKE_OUT_SYSTEM && sysMakeStrategy == ExamConstant.MAKE_OUT_SYSTEM_SAMPLE)) &&
                (stemSort == ExamConstant.STEM_SORT_RANDOM || optionSort == ExamConstant.OPTION_SORT_RANDOM)) {
            questions = groupSubject(examPaperVO, questions, false);
            logger.info("^^^^^^^#########################$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$####################根据策略2，准备完成组装出题数据的条数={}", questions.size());
        }


        StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
        BeanUtils.copyProperties(examPaperVO, studentExamPaperVO);
        studentExamPaperVO.setQuestionNumber(questions.size());
        //studentExamPaperVO.setQuestions(questions);

        //生成答卷ID
        Long answerId = idGenerator.generate();
        studentExamPaperVO.setAnswerId(answerId);
        //添加答卷
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setId(answerId);
        trExamAnswer.setTrainingProjectId(examPaperVO.getTrainingProjectId());
        trExamAnswer.setExamId(examPaperVO.getExamId());
        trExamAnswer.setAccountId(examPaperVO.getAccountId());
        trExamAnswer.setStartTime(createTime);
        trExamAnswer.setTerminalType(examPaperVO.getTerminalType());
        trExamAnswer.setState(0);
        trExamAnswer.setCreateTime(createTime);
        trExamAnswer.setCreateById(examPaperVO.getAccountId());
        //trExamAnswer.setCreateByName(examPaperVO.getAccountName());
        trExamAnswer.setCreateByName("");
        trExamAnswer.setUpdateById(examPaperVO.getAccountId());
        //trExamAnswer.setUpdateByName(examPaperVO.getAccountName());
        trExamAnswer.setUpdateByName("");
        trExamAnswer.setUpdateTime(createTime);
        trExamAnswer.setCompanyId(examPaperVO.getCompanyId());
        trExamAnswer.setSiteId(examPaperVO.getSiteId());
        trExamAnswer.setOrgId(examPaperVO.getOrgId());
        int count = trExamAnswerMapper.insert(trExamAnswer);
        //添加答案题目
        if (count > 0) {
            TrExamAnswerQuestion trExamAnswerQuestion = new TrExamAnswerQuestion();
            Long index = 0L;
            CardVO cardVO;
            List<CardVO> cardVOS = new ArrayList<CardVO>(questions.size());
            List<QuestionListVO> questionListVOS = new ArrayList<QuestionListVO>(questions.size());
            for (QuestionListVO questionListVO : questions) {
                Long no = index++;
                questionListVO.setIndex(no);
                questionListVO.setSort(no.intValue());
                cardVO = new CardVO();
                cardVO.setIndex(no);
                cardVO.setFlag(questionListVO.getFlag());
                cardVO.setAnswerFlag(questionListVO.getFlag());
                cardVOS.add(cardVO);

                //添加答案题目
                Long id = idGenerator.generate();
                trExamAnswerQuestion.setId(id);
                trExamAnswerQuestion.setAnswerId(answerId);
                trExamAnswerQuestion.setExamQuestionId(questionListVO.getExamQuestionId());
                trExamAnswerQuestion.setLibraryId(questionListVO.getLibraryId());
                trExamAnswerQuestion.setSubjectId(questionListVO.getSubjectId());
                trExamAnswerQuestion.setAccountId(examPaperVO.getAccountId());
                trExamAnswerQuestion.setCreateById(examPaperVO.getAccountId());
                //trExamAnswerQuestion.setCreateByName(examPaperVO.getAccountName());
                trExamAnswerQuestion.setCreateByName("");
                trExamAnswerQuestion.setCreateTime(createTime);
                trExamAnswerQuestion.setUpdateById(examPaperVO.getAccountId());
                //trExamAnswerQuestion.setUpdateByName(examPaperVO.getAccountName());
                trExamAnswerQuestion.setUpdateByName("");
                trExamAnswerQuestion.setUpdateTime(createTime);
                trExamAnswerQuestion.setSort(no);
                trExamAnswerQuestionMapper.insert(trExamAnswerQuestion);

                questionListVO.setAnswerQuestionId(id);
                questionListVOS.add(questionListVO);
            }
            studentExamPaperVO.setQuestions(questionListVOS);
            studentExamPaperVO.setCardVOS(cardVOS);
        }

        //将考生的组卷信息保存到数据库中
        ExamStudentAutoAnswerInfo entity = new ExamStudentAutoAnswerInfo();
        entity.setId(answerId);
        entity.setAccountId(accountId);
        entity.setExamId(examId);
        entity.setOrgId(examPaperVO.getOrgId());
        entity.setCompanyId(examPaperVO.getCompanyId());
        entity.setSiteId(examPaperVO.getOrgId());
        entity.setCreateById(accountId);
        //entity.setCreateByName(examPaperVO.getAccountName());
        entity.setCreateByName("");
        entity.setCreateTime(createTime);
        entity.setUpdateById(accountId);
        //entity.setUpdateByName(examPaperVO.getAccountName());
        entity.setUpdateByName("");
        entity.setUpdateTime(createTime);
        String content = JSON.toJSONString(studentExamPaperVO);
        entity.setContent(content);
        examStudentAutoAnswerInfoMapper.insert(entity);
        /*try {
        } catch (Exception e) {
            logger.error("考生:{} 名字:{} ,组卷信息保存失败examId = {} ,answerId = {}. 异常信息：{}",accountId,examPaperVO.getAccountName(),examId,answerId,e);
        }*/

        return studentExamPaperVO;
    }

    /**
     * 组合试题和选项，生成新的试题
     *
     * @param sysQuestionOptions 系统出题规则
     * @param groupQuestions     试题集合
     * @return
     */
    private List<QuestionListVO> groupSubject(final ExamPaperVO examPaperVO, final List<QuestionListVO> groupQuestions, boolean isGetSystemSubject) {
        List<QuestionListVO> questions = null;

        //处理题干排序方式
        boolean isRandom = false;

        //题型随机了，那所有试题的题干也随机
//        if (examPaperVO.getTypeSort() == ExamConstant.TYPE_SORT_RANDOM) {
//            isRandom = true;
//        } else {
        //题干随机
        if (examPaperVO.getStemSort() == ExamConstant.STEM_SORT_RANDOM) {
            isRandom = true;
        }
//        }

        logger.info("准备开始处理试题个数={}", groupQuestions.size());
        // 系统出题状态
        Integer makeStrategy = examPaperVO.getMakeStrategy();
        Integer sysMakeStrategy = examPaperVO.getSysMakeStrategy();

        //题型排序
        List<ExamQuestionSortVO> examQuestionSorts = examPaperVO.getExamQuestionSorts();
        if (examQuestionSorts != null && examQuestionSorts.size() > 0) {
            logger.info("非随机试题的试题个数={},题型排序对象={}", groupQuestions.size(), JSON.toJSONString(examQuestionSorts));
            //题型排序，按指定类型
            questions = new ArrayList<QuestionListVO>();
            List<QuestionListVO> randQuestions = new ArrayList<QuestionListVO>();

            //先添加必答题然后从题库中抽题
            for (ExamQuestionSortVO item : examQuestionSorts) {
                randQuestions.clear();
                Integer sortType = item.getType();//排序的题型
                //按题型添加必答题
                if (!CollectionUtils.isEmpty(groupQuestions)) {
                    for (QuestionListVO groupItem : groupQuestions) {
                        Integer groupType = groupItem.getType();
                        if (sortType == groupType) {
                            randQuestions.add(groupItem);
                        }
                    }
                }

                if (isRandom) {
                    int indexs[] = RandomUtil.getRandom(randQuestions.size(), randQuestions.size());
                    for (int i = 0; i < indexs.length; i++) {
                        questions.add(randQuestions.get(indexs[i]));
                    }
                } else {
                    questions.addAll(randQuestions);
                }

                //按题型从题库中抽题
                if (makeStrategy == ExamConstant.MAKE_OUT_SYSTEM && isGetSystemSubject) {
                    List<QuestionOptionSystemListVO> sysQuestionOptions = examPaperVO.getQuestionSystemOptions();
                    getLibrarySubjectRandom(sysQuestionOptions, sortType, examPaperVO.getLibQuestions(), questions, isRandom, sysMakeStrategy);
                }
            }
        } else {
            //题型排序，默认排序
            logger.info("随机试题处理开始");
            questions = new ArrayList<QuestionListVO>();
            if (isRandom) {
                //随机排序，添加必答题
                int size = groupQuestions.size();
                int indexs[] = RandomUtil.getRandom(size, size);
                if (!CollectionUtils.isEmpty(groupQuestions)) {
                    for (int i = 0; i < indexs.length; i++) {
                        questions.add(groupQuestions.get(indexs[i]));
                    }
                }
            } else {
                //正常排序，添加必答题
                questions = groupQuestions;
            }

            if (makeStrategy == ExamConstant.MAKE_OUT_SYSTEM && isGetSystemSubject) {
                //题库中抽题
                getLibrarySubjectRandom(examPaperVO.getQuestionSystemOptions(), null, examPaperVO.getLibQuestions(), questions, isRandom, sysMakeStrategy);
            }
        }

        logger.info("随机试题处理结束。试题个数={}", questions.size());
		
		
		
		
		/*
		 
		// 判断是否是系统出题
		if(makeStrategy == ExamConstant.MAKE_OUT_SYSTEM){
			//系统出题，按指定题型添加试题
			questions = new ArrayList<QuestionListVO>();
			//得到要抽题的题库
			List<QuestionOptionSystemListVO> sysQuestionOptions = examPaperVO.getQuestionSystemOptions();	
			//按指定题型添加试题
			if(examQuestionSorts != null && examQuestionSorts.size() > 0){
				//先添加必答题然后从题库中抽题
				for(ExamQuestionSortVO item : examQuestionSorts){
					Integer sortType = item.getType();//排序的题型
					//按题型添加必答题
					for(QuestionListVO groupItem : groupQuestions){
						Integer groupType = groupItem.getType();
						if(sortType == groupType){
							questions.add(groupItem);
						}
					}
					
					//按题型从题库中抽题
					getLibrarySubjectRandom(sysQuestionOptions, sortType, examPaperVO.getLibQuestions(), questions, isRandom);
				}
			}
		} else {
			//手工出题，按指定题型添加试题
			if(examQuestionSorts != null && examQuestionSorts.size() > 0){
				questions = new ArrayList<QuestionListVO>();
				
				for(ExamQuestionSortVO item : examQuestionSorts){
					Integer sortType = item.getType();//排序的题型
					//按题型添加必答题
					for(QuestionListVO groupItem : groupQuestions){
						Integer groupType = groupItem.getType();
						if(sortType == groupType){
							questions.add(groupItem); 
						}
					}
				}
			}
		}
		
		
		//题干排序（默认、随机）
		Integer stemSort = examPaperVO.getStemSort();
		if(stemSort != ExamConstant.STEM_SORT_TYPE){  
			questions = new ArrayList<QuestionListVO>();			
			if(stemSort == ExamConstant.STEM_SORT_RANDOM){
				//随机排序，添加必答题
				int size = groupQuestions.size();
				int indexs[] = RandomUtil.getRandom(size, size);
				for(int i = 0; i < indexs.length; i++){
					questions.add(groupQuestions.get(indexs[i]));
				}
			} else {
				//正常排序，添加必答题
				questions = groupQuestions;
			}
			
			if(makeStrategy == ExamConstant.MAKE_OUT_SYSTEM){
				//题库中抽题
				getLibrarySubjectRandom(examPaperVO.getQuestionSystemOptions(), null, examPaperVO.getLibQuestions(), questions, isRandom);
			}	
		}
		*/


        //选项随机排序
        Integer optionSort = examPaperVO.getOptionSort();
        if (optionSort == ExamConstant.OPTION_SORT_RANDOM) {
            List<QuestionOptionListVO> questionOptions = null;
            List<QuestionOptionListVO> newQuestionOptions = null;
            for (QuestionListVO item : questions) {
                newQuestionOptions = new ArrayList<QuestionOptionListVO>();
                questionOptions = item.getQuestionOptions();
                int size = questionOptions.size();
                int indexs[] = RandomUtil.getRandom(size, size);
                for (int i = 0; i < indexs.length; i++) {
                    newQuestionOptions.add(questionOptions.get(indexs[i]));
                }
                item.setQuestionOptions(newQuestionOptions);
            }
        }
        logger.info("随机试题处理结束,准备返回。试题个数={}", questions.size());
        return questions;
    }

    /**
     * 从题库中抽屉
     *
     * @param sysQuestionOptions 抽题题库
     * @param questionType       题型
     * @param libMapQuestions    题库中的所有题目
     * @param addQuestions       要添加的试题集合
     * @param isRandom           是否随机抽题
     */
    private void getLibrarySubjectRandom(List<QuestionOptionSystemListVO> sysQuestionOptions, Integer
            questionType,
                                         Map<String, List<QuestionListVO>> libMapQuestions, List<QuestionListVO> addQuestions,
                                         boolean isRandom, Integer sysMakeStrategy) {
        QuestionListVO questionListVO = null;

        if (questionType != null) {
            //按题型，抽取题目
            for (QuestionOptionSystemListVO libItem : sysQuestionOptions) {
                Integer libQueType = libItem.getType();//题库的题型
                if (questionType != null && questionType != libQueType) {
                    continue;
                }

                //题库ID主键
                Long libraryId = libItem.getLibraryId();
                //抽题数量
                Integer number = libItem.getNumber();
                if (number == null) {
                    number = 0;
                }
                //分数
                BigDecimal score = libItem.getScore();
                if (score == null) {
                    score = BigDecimal.valueOf(0);
                }

                //取出题库的试题
                List<QuestionListVO> libQuestions = libMapQuestions.get(libraryId.toString() + "_" + libQueType.toString());
                int size = libQuestions.size();
                number = number > size ? size : number;
                //随机抽取题目
                if (sysMakeStrategy == ExamConstant.MAKE_OUT_SYSTEM_RANDOM) {
                    int indexs[] = RandomUtil.getRandom(size, number);
                    for (int i = 0; i < indexs.length; i++) {
                        questionListVO = libQuestions.get(indexs[i]);
                        questionListVO.setScore(score);
                        questionListVO.setSort(i);
                        addQuestions.add(questionListVO);
                    }
                } else {
                    for (int i = 0; i < number; i++) {
                        questionListVO = libQuestions.get(i);
                        questionListVO.setScore(score);
                        questionListVO.setSort(i);
                        addQuestions.add(questionListVO);
                    }
                }

            }
        } else {
            //抽取所有，不按题型
            List<QuestionListVO> libQuestionAlls = new ArrayList<QuestionListVO>();
            List<QuestionListVO> libQues = null;

            for (QuestionOptionSystemListVO libItem : sysQuestionOptions) {
                Integer libQueType = libItem.getType();//题库的题型

                //题库ID主键
                Long libraryId = libItem.getLibraryId();
                //分数
                BigDecimal score = libItem.getScore();
                if (score == null) {
                    score = BigDecimal.valueOf(0);
                }
                Integer num = libItem.getNumber();
                //取出题库的试题
                libQues = libMapQuestions.get(libraryId.toString() + "_" + libQueType.toString());
                int size = libQues.size();
                num = num > size ? size : num;
                if (sysMakeStrategy == ExamConstant.MAKE_OUT_SYSTEM_RANDOM) {
                    int indexs[] = RandomUtil.getRandom(size, num);
                    for (int i = 0; i < indexs.length; i++) {
                        questionListVO = libQues.get(indexs[i]);
                        questionListVO.setScore(score);
                        questionListVO.setSort(i);
                        libQuestionAlls.add(questionListVO);
                    }
                } else {
                    for (int i = 0; i < num; i++) {
                        questionListVO = libQues.get(i);
                        questionListVO.setScore(score);
                        questionListVO.setSort(i);
                        libQuestionAlls.add(questionListVO);
                    }
                }
            }

            //随机抽取题目
            int size = libQuestionAlls.size();
            if (isRandom) {
                int indexs[] = RandomUtil.getRandom(size, size);
                for (int i = 0; i < indexs.length; i++) {
                    questionListVO = libQuestionAlls.get(indexs[i]);
                    questionListVO.setSort(i);
                    addQuestions.add(questionListVO);
                }
            } else {
                for (int i = 0; i < size; i++) {
                    questionListVO = libQuestionAlls.get(i);
                    questionListVO.setSort(i);
                    addQuestions.add(questionListVO);
                }
            }
        }

    }

    public Long isExists(Long accountId, Long examId) {
        Object result = null;
        ValueOperations<Serializable, Object> operations = redisTemplate.opsForValue();
        result = operations.get(accountId.toString() + "_" + examId.toString());
        if (null == result) {
            return -1L;
        }

        StudentExamPaperVO studentExamPaperVO = (StudentExamPaperVO) result;

        return studentExamPaperVO.getAnswerId();
    }

    @ExamCachDel(cacheName = "'accountId'+'_'+#accountId+'_'+#examId", cacheKey = "'accountId'+'_'+#accountId+'_'+#examId")
    public void clearStudentExam(Long accountId, Long examId) {
        logger.info("删除考生:" + accountId.toString() + " 考试:" + examId.toString() + " 的缓存");
    }

    @Override
    @ExamCachDel(cacheName = "'exam'+'_'+#examId", cacheKey = "'exam'+'_'+#examId")
    public void clearExam(Long examId) {
        logger.info("删除考试:" + examId.toString() + " 的缓存");
    }

    @Override
    public void updateExamAnswerState(Long answerId) {
        TrExamAnswer entity = new TrExamAnswer();
        entity.setId(answerId);
        entity.setState(-1);
        trExamAnswerMapper.updateById(entity);
    }

    @Override
    @ExamCach(cacheName = "'accountId'+'_'+#accountId+'_'+#examId", cacheKey = "'accountId'+'_'+#accountId+'_'+#examId", expireTime = "#time")
    public StudentExamPaperVO getMakeStudentExam(Long accountId, Long examId, Long answerId, Long time) {
        StudentExamPaperVO studentExamPaperVO = null;
        ExamStudentAutoAnswerInfo answerInfo = examStudentAutoAnswerInfoMapper.selectById(answerId);
        String content = answerInfo.getContent();
        if (!StringUtils.isBlank(content)) {
            studentExamPaperVO = JSON.toJavaObject(JSON.parseObject(content), StudentExamPaperVO.class);
        }
        return studentExamPaperVO;
    }
}
