package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.domain.TrExamRemindTime;
import com.yizhi.application.mapper.TrExamRemindTimeMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamRemindTimeService;
import com.yizhi.exam.application.vo.TrExamRemindTimeVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * 提醒时间设置 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamRemindTimeServiceImpl extends ServiceImpl<TrExamRemindTimeMapper, TrExamRemindTime>
		implements ITrExamRemindTimeService {

	@Autowired
	private IdGenerator idGenerator;

	public List<TrExamRemindTimeVO> listTrExamRemindTime(Long trExamRemindId) {
		SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		
		List<TrExamRemindTimeVO> list = new ArrayList<TrExamRemindTimeVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("tr_exam_remind_id", trExamRemindId);
		List<TrExamRemindTime> selectByMap = this.selectByMap(map);
		TrExamRemindTimeVO vo = null;
		for (TrExamRemindTime tt : selectByMap) {
			vo = new TrExamRemindTimeVO();
			vo.setId(tt.getId());
			vo.setTrExamRemindId(trExamRemindId);
			vo.setType(tt.getType());
			if(tt.getType() == 3){//自定义类行，要设置时间
				vo.setCustomDate(formatDate.format(tt.getCustomDate()));
			}
			vo.setTriggerTime(tt.getTriggerTime());
			list.add(vo);
		}
		return list;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamRemindTimeVoList(List<TrExamRemindTimeVO> trExamRemindTimeVoList, Long remaindId, String accountName, Long accountId) {
		List<TrExamRemindTime> list = new ArrayList<TrExamRemindTime>();
		List<TrExamRemindTime> updateList = new ArrayList<TrExamRemindTime>();
		TrExamRemindTime tet = null;
		SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		
		try {
			for (TrExamRemindTimeVO vo : trExamRemindTimeVoList) {
				tet = new TrExamRemindTime();
				if (vo.getId() == null) {
					tet.setId(idGenerator.generate());
					tet.setTrExamRemindId(remaindId);
					tet.setType(vo.getType());
					tet.setTriggerTime(vo.getTriggerTime());
					tet.setState(ExamConstant.FIRST);
					if(vo.getType() == 3){//自定义类行，要设置时间
						tet.setCustomDate(formatDate.parse(vo.getCustomDate()));
					}
					setInsertCloumn(tet, true, accountName, accountId);
					list.add(tet);
				} else {
					tet = this.selectById(vo.getId());
					if(null != tet){
						tet.setType(vo.getType());
						tet.setTriggerTime(vo.getTriggerTime());
						if(vo.getType() == 3){//自定义类行，要设置时间
							tet.setCustomDate(formatDate.parse(vo.getCustomDate()));
						}
						tet.setState(vo.getState());
						setInsertCloumn(tet, false, accountName, accountId);
						updateList.add(tet);
					}
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		if (updateList.size() > 0) {
			this.updateBatchById(updateList);
		}
		return true;
	}

	public boolean copyTrExamRemindTime(Long oldId, Long remaindId, String accountName, Long accountId) {
		List<TrExamRemindTime> list = new ArrayList<TrExamRemindTime>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("tr_exam_remind_id", oldId);
		List<TrExamRemindTime> selectByMap = this.selectByMap(map);
		TrExamRemindTime tq = null;
		for (TrExamRemindTime tet : selectByMap) {
			tq = new TrExamRemindTime();
			BeanUtils.copyProperties(tet, tq);
			tq.setId(idGenerator.generate());
			tq.setTrExamRemindId(remaindId);
			tq.setState(ExamConstant.FIRST);
			setInsertCloumn(tq, true, accountName, accountId);
			list.add(tq);
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}

	public void setInsertCloumn(TrExamRemindTime tq, boolean boo, String accountName, Long accountId) {

		if (boo) {
			tq.setCreateById(accountId);
			tq.setCreateByName(accountName);
			tq.setCreateTime(new Date());
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		} else {
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		}
	}
}