package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.MarkStudentVO;
import com.yizhi.exam.application.vo.StudentListOutVO;
import com.yizhi.exam.application.vo.StudentListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by fanchunhui on 2018/3/21.
 *考试阅卷
 */
@FeignClient(name = "exam", contextId = "ExamOnlineReadOverClient")
public interface ExamOnlineReadOverClient {

    @GetMapping("/manage/exam/marking/list")
    Map<String,Object> getExamMarkingList(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

//    @GetMapping("/manage/exam/marking/student/list")
//    Map<String,Object> getExamMarking(@RequestParam("examId")Long examId,@RequestParam("userName") String userName, @RequestParam("name")String name,@RequestParam("depart") String depart,@RequestParam("pageSize") Integer pageSize,@RequestParam("pageNo") Integer pageNo);
    @GetMapping("/manage/exam/marking/student/list")
    StudentListOutVO selectList(@RequestBody StudentListVO studentListVO);

    /**
     * 阅卷保存
     * @param
     * @return
     */
    @PostMapping(value = "/manage/exam/marking/student/save")
    Integer insertByFile(@RequestBody MarkStudentVO markStudentVO);

    /**
     * 批阅答卷
     * @param
     * @return
     */
    /*@PostMapping(value = "/manage/exam/marking/student")
    PaperInspectionVo  findByExamVo(@RequestParam("id")Long id,@RequestParam("accountName") String accountName);*/

    @GetMapping(value = "/manage/exam/marking/student")
    MarkStudentVO markingStudent(@RequestParam("readOverId") Long readOverId);

    /**
     * 根据考试ID查询已阅卷人数
     * */
    @GetMapping("/manage/exam/read/count")
    int readCount(@RequestParam("examId") Long examId);

    /**
     * 获取答卷信息
     * */
    @PostMapping("/manage/exam/read/info")
    MarkStudentVO getExamOnlineReadOverById(@RequestBody MarkStudentVO markStudentVO);

    /**
     * 管理端阅卷管理添加考试结果导出
     * @param examId
     * @return
     */
    @GetMapping("/manage/exam/read/examExport")
    String studentExamExport(@RequestParam(name = "examId") Long examId);

    /**
     * 阅卷管理加合格人数
     * @param examIds
     * @return
     */
    @GetMapping("/manage/exam/read/getQualifiedNum")
    Map<Long,Integer> getQualifiedNum(@RequestParam("examIds") List<Long> examIds);

}
