package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.ExamSystemQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈系统出题规则〉
 *
 * @author phone
 * @create 2018/5/25
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamSystemQuestionClient")
public interface ExamSystemQuestionClient {

    @PostMapping("/manage/exam/system/question/insert/all")
    boolean insert(@RequestBody ExamSystemQuestionVO examSystemQuestionVO);

    @GetMapping("/manage/exam/system/question/select")
    List<QuestionPreview> selectExamSystemQuestion(@RequestParam("examId") Long examId);

}