package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.StatisticsExamLearnMetadata;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/8/17 13:16
 * @Description:考试信息整合入库接口
 */
@FeignClient(name = "exam", contextId = "StatisticsExamMetadataClient")
public interface StatisticsExamMetadataClient {

    @GetMapping("/manage/report/exam/asynchronous/load")
    public String AsynchronousExam(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);


    /**
     * 报表服务获取所有考试列表
     *
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/manage/report/exam/getAllExams")
    public List<Exam> getAllExams(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    /**
     * 报表服务获取所有考试最早开始时间
     *
     * @return
     */
    @GetMapping("/manage/report/exam/selectRecordMinTime")
    public Date selectRecordMinTime();

    /**
     * 报表服务获取可见范围id(人或者组织)
     *
     * @param examId
     * @return
     */
    @GetMapping("/manage/report/exam/getRangeIds")
    public List<Long> getRangeIds(@RequestParam("examId") Long examId);

    /**
     *考试报表服务获取入库记录
     * @param examId
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/manage/report/exam/getRecords")
    public List<StatisticsExamLearnMetadata> getRecords(@RequestParam("examId") Long examId, @RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    /**
     * 获取所有考试siteId
     * @return
     */
    @GetMapping("/manage/report/exam/getAllExamSiteIds")
    public List<Long> getAllExamSiteIds();

}
