package com.yizhi.exam.application.vo;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamQuestionSubjectVo", description = "")
@Data
public class ExamQuestionSubjectVo {
	
	@ApiModelProperty(value = "答卷题目ID，主键")
	private Long id;
	
	@ApiModelProperty(value = "答卷_ID，外键")
	private Long answerId;

	@ApiModelProperty(value = "考试题目_ID，外键")
	private Long examQuestionId;

	@ApiModelProperty(value = "题库主键_ID，外键")
	private Long libraryId;

	@ApiModelProperty(value = "题目主键_ID，外键")
	private Long subjectId;
	
	@ApiModelProperty(value = "题干，题目内容")
    private String stem;
    
	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
    private Integer type;
	
	@ApiModelProperty(value = "答案，存放题目ID")
	private String answer;
	
	@ApiModelProperty(value = "排序")
	private Integer sort;
	
	@ApiModelProperty(value = "得分")
	private BigDecimal score;
	
	@ApiModelProperty(value = "题目分数")
	private BigDecimal scoreNum;
	
	@ApiModelProperty(value = "正确答案")
	private String rightAnswer;
	
	@ApiModelProperty(value = "评分说明，允许为空（文本），对题型是问答题有效")
	private String scoreRule;
	
	@ApiModelProperty(value = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	private String stemAppendixUrl;

}
